/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostHealthStatus;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Collection;
import java.util.Map;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.LIVELINESS, order=1.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class HostsHeartbeatCheck
extends ClusterCheck {
    static final UpgradeCheckDescription HOSTS_HEARTBEAT = new UpgradeCheckDescription("HOSTS_HEARTBEAT", UpgradeCheckType.HOST, "All hosts must be communicating with Ambari. Hosts which are not reachable should be placed in Maintenance Mode.", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"There are hosts which are not communicating with Ambari.").build());

    public HostsHeartbeatCheck() {
        super(HOSTS_HEARTBEAT);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        Collection<Host> hosts = cluster.getHosts();
        for (Host host : hosts) {
            HostHealthStatus.HealthStatus hostHealth = host.getHealthStatus().getHealthStatus();
            MaintenanceState maintenanceState = host.getMaintenanceState(cluster.getClusterId());
            switch (hostHealth) {
                case UNHEALTHY: 
                case UNKNOWN: {
                    if (maintenanceState != MaintenanceState.OFF) break;
                    result.getFailedOn().add(host.getHostName());
                    result.getFailedDetail().add(new ClusterCheck.HostDetail(host.getHostId(), host.getHostName()));
                    break;
                }
            }
        }
        if (!result.getFailedOn().isEmpty()) {
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(this.getFailReason(result, request));
        }
        return result;
    }
}

