/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Collection;
import java.util.Map;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.MAINTENANCE_MODE, order=7.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class HostMaintenanceModeCheck
extends ClusterCheck {
    public static final String KEY_CANNOT_START_HOST_ORDERED = "cannot_upgrade_mm_hosts";
    static final UpgradeCheckDescription HOSTS_MAINTENANCE_MODE = new UpgradeCheckDescription("HOSTS_MAINTENANCE_MODE", UpgradeCheckType.HOST, "Hosts in Maintenance Mode will be excluded from the upgrade.", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"There are hosts in Maintenance Mode which excludes them from being upgraded.").put((Object)"cannot_upgrade_mm_hosts", (Object)"The following hosts cannot be in Maintenance Mode: {{fails}}.").build());

    public HostMaintenanceModeCheck() {
        super(HOSTS_MAINTENANCE_MODE);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        Collection<Host> hosts = cluster.getHosts();
        for (Host host : hosts) {
            MaintenanceState maintenanceState = host.getMaintenanceState(cluster.getClusterId());
            if (maintenanceState == MaintenanceState.OFF) continue;
            result.getFailedOn().add(host.getHostName());
            result.getFailedDetail().add(new ClusterCheck.HostDetail(host.getHostId(), host.getHostName()));
        }
        if (!result.getFailedOn().isEmpty()) {
            UpgradeCheckStatus status = request.getUpgradeType() == UpgradeType.HOST_ORDERED ? UpgradeCheckStatus.FAIL : UpgradeCheckStatus.WARNING;
            result.setStatus(status);
            String failReason = request.getUpgradeType() == UpgradeType.HOST_ORDERED ? this.getFailReason(KEY_CANNOT_START_HOST_ORDERED, result, request) : this.getFailReason(result, request);
            result.setFailReason(failReason);
        }
        return result;
    }
}

