/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.DEFAULT, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class HealthCheck
extends ClusterCheck {
    private static final List<AlertState> ALERT_STATES = Arrays.asList(AlertState.WARNING, AlertState.CRITICAL);
    @Inject
    Provider<AlertsDAO> alertsDAOProvider;
    static final UpgradeCheckDescription HEALTH = new UpgradeCheckDescription("HEALTH", UpgradeCheckType.CLUSTER, "Cluster Health", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following issues have been detected on this cluster and should be addressed before upgrading: %s").build());

    public HealthCheck() {
        super(HEALTH);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        AlertsDAO alertsDAO = (AlertsDAO)this.alertsDAOProvider.get();
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        List<AlertCurrentEntity> alerts = alertsDAO.findCurrentByCluster(cluster.getClusterId());
        ArrayList<CallSite> errorMessages = new ArrayList<CallSite>();
        for (AlertCurrentEntity alert : alerts) {
            AlertHistoryEntity alertHistory = alert.getAlertHistory();
            AlertState alertState = alertHistory.getAlertState();
            if (!ALERT_STATES.contains((Object)alertState) || alert.getMaintenanceState().equals((Object)MaintenanceState.ON)) continue;
            String state = alertState.name();
            String label = alertHistory.getAlertDefinition().getLabel();
            String hostName = alertHistory.getHostName();
            if (hostName == null) {
                errorMessages.add((CallSite)((Object)(state + ": " + label)));
            } else {
                errorMessages.add((CallSite)((Object)(state + ": " + label + ": " + hostName)));
            }
            result.getFailedDetail().add(new AlertDetail(state, label, hostName));
        }
        if (!errorMessages.isEmpty()) {
            result.getFailedOn().add(clusterName);
            result.setStatus(UpgradeCheckStatus.WARNING);
            String failReason = this.getFailReason(result, request);
            result.setFailReason(String.format(failReason, StringUtils.join(errorMessages, (String)System.lineSeparator())));
        }
        return result;
    }

    private static class AlertDetail {
        @JsonProperty(value="state")
        public String state;
        @JsonProperty(value="label")
        public String label;
        @JsonProperty(value="host_name")
        public String hostName;

        AlertDetail(String state, String label, String hostName) {
            this.state = state;
            this.label = label;
            this.hostName = hostName;
        }
    }
}

