/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(order=98.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class HardcodedStackVersionPropertiesCheck
extends ClusterCheck {
    static final UpgradeCheckDescription HARDCODED_STACK_VERSION_PROPERTIES_CHECK = new UpgradeCheckDescription("HARDCODED_STACK_VERSION_PROPERTIES_CHECK", UpgradeCheckType.CLUSTER, "Found hardcoded stack version in property value.", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"Some properties seem to contain hardcoded stack version string \"%s\". That is a potential problem when doing stack update.").build());

    public HardcodedStackVersionPropertiesCheck() {
        super(HARDCODED_STACK_VERSION_PROPERTIES_CHECK);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(request.getClusterName());
        HashSet versions = new HashSet();
        HashSet<String> failures = new HashSet<String>();
        HashSet<String> failedVersions = new HashSet<String>();
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        for (Map.Entry<String, DesiredConfig> configEntry : desiredConfigs.entrySet()) {
            String configType = configEntry.getKey();
            DesiredConfig desiredConfig = configEntry.getValue();
            Config config = cluster.getConfig(configType, desiredConfig.getTag());
            Map<String, String> properties = config.getProperties();
            for (Map.Entry<String, String> property : properties.entrySet()) {
                for (String version : versions) {
                    Pattern searchPattern = HardcodedStackVersionPropertiesCheck.getHardcodeSearchPattern(version);
                    if (!HardcodedStackVersionPropertiesCheck.stringContainsVersionHardcode(property.getValue(), searchPattern)) continue;
                    failedVersions.add(version);
                    failures.add(String.format("%s/%s found a hardcoded value %s", configType, property.getKey(), version));
                }
            }
        }
        if (failures.size() > 0) {
            result.setStatus(UpgradeCheckStatus.WARNING);
            String failReason = this.getFailReason(result, request);
            result.setFailReason(String.format(failReason, StringUtils.join(failedVersions, (char)',')));
            result.setFailedOn(new LinkedHashSet(failures));
        } else {
            result.setStatus(UpgradeCheckStatus.PASS);
        }
        return result;
    }

    public static Pattern getHardcodeSearchPattern(String hdpVersion) {
        return Pattern.compile("(?<!-Dhdp\\.version=)" + hdpVersion.replace(".", "\\."));
    }

    public static boolean stringContainsVersionHardcode(String string, Pattern searchPattern) {
        Matcher matcher = searchPattern.matcher(string);
        return matcher.find();
    }
}

