/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.PersistService;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.audit.AuditLoggerModule;
import id.onyx.obdp.server.checks.DatabaseConsistencyCheckHelper;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.ldap.LdapModule;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.utils.EventBusSynchronizer;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConsistencyChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseConsistencyChecker.class);
    private PersistService persistService;
    private DBAccessor dbAccessor;
    private Injector injector;

    @Inject
    public DatabaseConsistencyChecker(DBAccessor dbAccessor, Injector injector, PersistService persistService) {
        this.dbAccessor = dbAccessor;
        this.injector = injector;
        this.persistService = persistService;
    }

    public void startPersistenceService() {
        this.persistService.start();
    }

    public void stopPersistenceService() {
        this.persistService.stop();
    }

    public static void main(String[] args) throws Exception {
        DatabaseConsistencyChecker databaseConsistencyChecker = null;
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{new CheckHelperControllerModule(), new CheckHelperAuditModule(), new LdapModule()});
            databaseConsistencyChecker = (DatabaseConsistencyChecker)injector.getInstance(DatabaseConsistencyChecker.class);
            databaseConsistencyChecker.startPersistenceService();
            DatabaseConsistencyCheckHelper.runAllDBChecks(false);
            DatabaseConsistencyCheckHelper.checkHostComponentStates();
            DatabaseConsistencyCheckHelper.checkServiceConfigs();
            databaseConsistencyChecker.stopPersistenceService();
        }
        catch (Throwable e) {
            try {
                if (e instanceof OBDPException) {
                    LOG.error("Exception occurred during database check:", e);
                    throw (OBDPException)e;
                }
                LOG.error("Unexpected error, database check failed", e);
                throw new Exception("Unexpected error, database check failed", e);
            }
            catch (Throwable throwable) {
                DatabaseConsistencyCheckHelper.closeConnection();
                if (DatabaseConsistencyCheckHelper.getLastCheckResult().isErrorOrWarning()) {
                    String ambariDBConsistencyCheckLog = "obdp-server-check-database.log";
                    ch.qos.logback.classic.Logger dbConsistencyCheckHelperLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(DatabaseConsistencyCheckHelper.class);
                    Iterator index = dbConsistencyCheckHelperLogger.iteratorForAppenders();
                    while (index.hasNext()) {
                        Appender appender = (Appender)index.next();
                        if (!(appender instanceof FileAppender)) continue;
                        ambariDBConsistencyCheckLog = ((FileAppender)appender).getFile();
                        break;
                    }
                    ambariDBConsistencyCheckLog = ambariDBConsistencyCheckLog.replace("//", "/");
                    if (DatabaseConsistencyCheckHelper.getLastCheckResult().isError()) {
                        System.out.print(String.format("DB configs consistency check failed. Run \"obdp-server start --skip-database-check\" to skip. You may try --auto-fix-database flag to attempt to fix issues automatically. If you use this \"--skip-database-check\" option, do not make any changes to your cluster topology or perform a cluster upgrade until you correct the database consistency issues. See \"%s\" for more details on the consistency issues.", ambariDBConsistencyCheckLog));
                    } else {
                        System.out.print(String.format("DB configs consistency check found warnings. See \"%s\" for more details.", ambariDBConsistencyCheckLog));
                    }
                } else {
                    System.out.print("No errors and warnings were found.");
                }
                throw throwable;
            }
        }
        DatabaseConsistencyCheckHelper.closeConnection();
        if (DatabaseConsistencyCheckHelper.getLastCheckResult().isErrorOrWarning()) {
            String ambariDBConsistencyCheckLog = "obdp-server-check-database.log";
            ch.qos.logback.classic.Logger dbConsistencyCheckHelperLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(DatabaseConsistencyCheckHelper.class);
            Iterator index = dbConsistencyCheckHelperLogger.iteratorForAppenders();
            while (index.hasNext()) {
                Appender appender = (Appender)index.next();
                if (!(appender instanceof FileAppender)) continue;
                ambariDBConsistencyCheckLog = ((FileAppender)appender).getFile();
                break;
            }
            ambariDBConsistencyCheckLog = ambariDBConsistencyCheckLog.replace("//", "/");
            if (DatabaseConsistencyCheckHelper.getLastCheckResult().isError()) {
                System.out.print(String.format("DB configs consistency check failed. Run \"obdp-server start --skip-database-check\" to skip. You may try --auto-fix-database flag to attempt to fix issues automatically. If you use this \"--skip-database-check\" option, do not make any changes to your cluster topology or perform a cluster upgrade until you correct the database consistency issues. See \"%s\" for more details on the consistency issues.", ambariDBConsistencyCheckLog));
            } else {
                System.out.print(String.format("DB configs consistency check found warnings. See \"%s\" for more details.", ambariDBConsistencyCheckLog));
            }
        } else {
            System.out.print("No errors and warnings were found.");
        }
    }

    public static class CheckHelperControllerModule
    extends ControllerModule {
        @Override
        protected void configure() {
            super.configure();
            EventBusSynchronizer.synchronizeAmbariEventPublisher(this.binder());
        }
    }

    public static class CheckHelperAuditModule
    extends AuditLoggerModule {
        @Override
        protected void configure() {
            super.configure();
        }
    }
}

