/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.state.ConfigMergeHelper;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(order=99.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class ConfigurationMergeCheck
extends ClusterCheck {
    @Inject
    ConfigMergeHelper m_mergeHelper;
    static final UpgradeCheckDescription CONFIG_MERGE = new UpgradeCheckDescription("CONFIG_MERGE", UpgradeCheckType.CLUSTER, "Configuration Merge Check", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following config types will have values overwritten: %s").build());

    public ConfigurationMergeCheck() {
        super(CONFIG_MERGE);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
        Map<String, Map<String, ConfigMergeHelper.ThreeWayValue>> changes = this.m_mergeHelper.getConflicts(request.getClusterName(), new StackId(repositoryVersion.getStackId()));
        HashSet<String> failedTypes = new HashSet<String>();
        for (Map.Entry<String, Map<String, ConfigMergeHelper.ThreeWayValue>> entry : changes.entrySet()) {
            for (Map.Entry<String, ConfigMergeHelper.ThreeWayValue> configEntry : entry.getValue().entrySet()) {
                MergeDetail md;
                ConfigMergeHelper.ThreeWayValue twv = configEntry.getValue();
                if (null == twv.oldStackValue) {
                    failedTypes.add(entry.getKey());
                    result.getFailedOn().add(entry.getKey() + "/" + configEntry.getKey());
                    md = new MergeDetail();
                    md.type = entry.getKey();
                    md.property = configEntry.getKey();
                    md.current = twv.savedValue;
                    md.new_stack_value = twv.newStackValue;
                    md.result_value = md.current;
                    result.getFailedDetail().add(md);
                    continue;
                }
                if (twv.oldStackValue.equals(twv.savedValue) || null != twv.newStackValue && twv.oldStackValue.equals(twv.newStackValue)) continue;
                failedTypes.add(entry.getKey());
                result.getFailedOn().add(entry.getKey() + "/" + configEntry.getKey());
                md = new MergeDetail();
                md.type = entry.getKey();
                md.property = configEntry.getKey();
                md.current = twv.savedValue;
                md.new_stack_value = twv.newStackValue;
                md.result_value = md.current;
                result.getFailedDetail().add(md);
            }
        }
        if (result.getFailedOn().size() > 0) {
            result.setStatus(UpgradeCheckStatus.WARNING);
            String failReason = this.getFailReason(result, request);
            result.setFailReason(String.format(failReason, StringUtils.join(failedTypes, (String)", ")));
        } else {
            result.setStatus(UpgradeCheckStatus.PASS);
        }
        return result;
    }

    public static class MergeDetail {
        public String type = null;
        public String property = null;
        public String current = null;
        public String new_stack_value = null;
        public String result_value = null;
    }
}

