/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.orm.models.HostComponentSummary;
import id.onyx.obdp.server.state.CheckHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.LIVELINESS, order=2.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class ComponentsInstallationCheck
extends ClusterCheck {
    static final UpgradeCheckDescription COMPONENTS_INSTALLATION = new UpgradeCheckDescription("COMPONENTS_INSTALLATION", UpgradeCheckType.SERVICE, "All service components must be installed", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following Services must be reinstalled: {{fails}}. Try to reinstall the service components in INSTALL_FAILED state.").build());

    public ComponentsInstallationCheck() {
        super(COMPONENTS_INSTALLATION);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        HashSet<String> failedServiceNames = new HashSet<String>();
        HashSet<String> installFailedHostComponents = new HashSet<String>();
        Set<String> servicesInUpgrade = ((CheckHelper)this.checkHelperProvider.get()).getServicesInUpgrade(request);
        for (String serviceName : servicesInUpgrade) {
            Service service = cluster.getService(serviceName);
            if (service.getMaintenanceState() == MaintenanceState.ON) continue;
            Map<String, ServiceComponent> serviceComponents = service.getServiceComponents();
            for (Map.Entry<String, ServiceComponent> component : serviceComponents.entrySet()) {
                ServiceComponent serviceComponent = component.getValue();
                if (!serviceComponent.isVersionAdvertised()) continue;
                List<HostComponentSummary> hostComponentSummaries = HostComponentSummary.getHostComponentSummaries(service.getName(), serviceComponent.getName());
                for (HostComponentSummary hcs : hostComponentSummaries) {
                    Host host = ((Clusters)this.clustersProvider.get()).getHost(hcs.getHostName());
                    if (host.getMaintenanceState(cluster.getClusterId()) == MaintenanceState.ON || hcs.getCurrentState() != State.INSTALL_FAILED) continue;
                    result.getFailedDetail().add(hcs);
                    failedServiceNames.add(service.getName());
                    installFailedHostComponents.add(MessageFormat.format("[{0}:{1} on {2}]", service.getName(), serviceComponent.getName(), hcs.getHostName()));
                }
            }
        }
        if (!installFailedHostComponents.isEmpty()) {
            String message = MessageFormat.format("Service components in INSTALL_FAILED state: {0}.", StringUtils.join(installFailedHostComponents, (String)", "));
            result.setFailedOn(new LinkedHashSet(failedServiceNames));
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason("Found service components in INSTALL_FAILED state. Please re-install these components. " + message);
        }
        return result;
    }
}

