/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.serveraction.upgrades.DeleteUnsupportedServicesAndComponents;
import id.onyx.obdp.server.stack.upgrade.ClusterGrouping;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.ServerActionTask;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ServiceComponentSupport;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.INFORMATIONAL_WARNING, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING})
public class ComponentsExistInRepoCheck
extends ClusterCheck {
    public static final String AUTO_REMOVE = "auto_remove";
    public static final String MANUAL_REMOVE = "manual_remove";
    @Inject
    ServiceComponentSupport serviceComponentSupport;
    @Inject
    UpgradeHelper upgradeHelper;
    static final UpgradeCheckDescription COMPONENTS_EXIST_IN_TARGET_REPO = new UpgradeCheckDescription("COMPONENTS_EXIST_IN_TARGET_REPO", UpgradeCheckType.CLUSTER, "Check installed services which are not supported in the installed stack", (Map)new ImmutableMap.Builder().put((Object)"auto_remove", (Object)"The following services and/or components do not exist in the target stack and will be automatically removed during the upgrade.").put((Object)"manual_remove", (Object)"The following components do not exist in the target repository's stack. They must be removed from the cluster before upgrading.").build());

    public ComponentsExistInRepoCheck() {
        super(COMPONENTS_EXIST_IN_TARGET_REPO);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
        StackId stackId = new StackId(repositoryVersion.getStackId());
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(request.getClusterName());
        String stackName = stackId.getStackName();
        String stackVersion = stackId.getStackVersion();
        Collection<String> allUnsupported = this.serviceComponentSupport.allUnsupported(cluster, stackName, stackVersion);
        this.report(result, request, allUnsupported);
        return result;
    }

    private void report(UpgradeCheckResult result, UpgradeCheckRequest request, Collection<String> allUnsupported) throws OBDPException {
        if (allUnsupported.isEmpty()) {
            result.setStatus(UpgradeCheckStatus.PASS);
            return;
        }
        result.setFailedOn(new LinkedHashSet<String>(allUnsupported));
        if (this.hasDeleteUnsupportedServicesAction(this.upgradePack(request))) {
            result.setStatus(UpgradeCheckStatus.WARNING);
            result.setFailReason(this.getFailReason(AUTO_REMOVE, result, request));
        } else {
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(this.getFailReason(MANUAL_REMOVE, result, request));
        }
    }

    private UpgradePack upgradePack(UpgradeCheckRequest request) throws OBDPException {
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(request.getClusterName());
        return this.upgradeHelper.suggestUpgradePack(request.getClusterName(), cluster.getCurrentStackVersion(), new StackId(request.getTargetRepositoryVersion().getStackId()), Direction.UPGRADE, request.getUpgradeType(), null);
    }

    private boolean hasDeleteUnsupportedServicesAction(UpgradePack upgradePack) {
        return upgradePack.getAllGroups().stream().filter(ClusterGrouping.class::isInstance).flatMap(group -> ((ClusterGrouping)group).executionStages.stream()).map(executeStage -> executeStage.task).anyMatch(this::isDeleteUnsupportedTask);
    }

    private boolean isDeleteUnsupportedTask(Task task) {
        return task instanceof ServerActionTask && DeleteUnsupportedServicesAndComponents.class.getName().equals(((ServerActionTask)task).getImplementationClass());
    }
}

