/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.state.CheckHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.CheckQualification;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class ClusterCheck
implements UpgradeCheck {
    @Inject
    protected Provider<Clusters> clustersProvider;
    @Inject
    Provider<HostVersionDAO> hostVersionDaoProvider;
    @Inject
    Provider<RepositoryVersionDAO> repositoryVersionDaoProvider;
    @Inject
    Provider<UpgradeDAO> upgradeDaoProvider;
    @Inject
    Provider<RepositoryVersionHelper> repositoryVersionHelper;
    @Inject
    Provider<OBDPMetaInfo> obdpMetaInfo;
    @Inject
    Configuration config;
    @Inject
    Gson gson;
    @Inject
    Provider<CheckHelper> checkHelperProvider;
    private UpgradeCheckDescription m_description;

    protected ClusterCheck(UpgradeCheckDescription description) {
        this.m_description = description;
    }

    public UpgradeCheckDescription getCheckDescription() {
        return this.m_description;
    }

    public Set<String> getApplicableServices() {
        return Collections.emptySet();
    }

    public List<CheckQualification> getQualifications() {
        return Collections.emptyList();
    }

    public UpgradeCheckDescription getDescription() {
        return this.m_description;
    }

    protected String getFailReason(UpgradeCheckResult upgradeCheckResult, UpgradeCheckRequest request) throws OBDPException {
        return this.getFailReason("default", upgradeCheckResult, request);
    }

    protected String getProperty(UpgradeCheckRequest request, String configType, String propertyName) throws OBDPException {
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        DesiredConfig desiredConfig = desiredConfigs.get(configType);
        if (null == desiredConfig) {
            return null;
        }
        Config config = cluster.getConfig(configType, desiredConfig.getTag());
        Map<String, String> properties = config.getProperties();
        return properties.get(propertyName);
    }

    protected String getFailReason(String key, UpgradeCheckResult upgradeCheckResult, UpgradeCheckRequest request) throws OBDPException {
        String fail = this.m_description.getFailureReason(key);
        RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
        if (fail.contains("{{version}}") && null != repositoryVersion) {
            fail = fail.replace("{{version}}", repositoryVersion.getVersion());
        }
        if (fail.contains("{{fails}}")) {
            LinkedHashSet<String> names = upgradeCheckResult.getFailedOn();
            if (this.getDescription().getType() == UpgradeCheckType.SERVICE) {
                Clusters clusters = (Clusters)this.clustersProvider.get();
                OBDPMetaInfo metaInfo = (OBDPMetaInfo)this.obdpMetaInfo.get();
                Cluster c = clusters.getCluster(request.getClusterName());
                Map<String, ServiceInfo> services = metaInfo.getServices(c.getDesiredStackVersion().getStackName(), c.getDesiredStackVersion().getStackVersion());
                LinkedHashSet<String> displays = new LinkedHashSet<String>();
                for (String name : names) {
                    if (services.containsKey(name)) {
                        displays.add(services.get(name).getDisplayName());
                        continue;
                    }
                    displays.add(name);
                }
                names = displays;
            }
            fail = fail.replace("{{fails}}", this.formatEntityList(names));
        }
        return fail;
    }

    protected String formatEntityList(LinkedHashSet<String> entities) {
        if (entities == null || entities.isEmpty()) {
            return "";
        }
        StringBuilder formatted = new StringBuilder(StringUtils.join(entities, (String)", "));
        if (entities.size() > 1) {
            formatted.replace(formatted.lastIndexOf(","), formatted.lastIndexOf(",") + 1, " and");
        }
        return formatted.toString();
    }

    static class HostDetail
    implements Comparable<HostDetail> {
        @JsonProperty(value="host_id")
        final Long hostId;
        @JsonProperty(value="host_name")
        final String hostName;

        HostDetail(Long hostId, String hostName) {
            this.hostId = hostId;
            this.hostName = hostName;
        }

        public int hashCode() {
            return Objects.hash(this.hostId, this.hostName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostDetail other = (HostDetail)obj;
            return Objects.equals(this.hostId, other.hostId) && Objects.equals(this.hostName, other.hostName);
        }

        @Override
        public int compareTo(HostDetail other) {
            return this.hostName.compareTo(other.hostName);
        }
    }

    static class ServiceComponentDetail
    implements Comparable<ServiceComponentDetail> {
        @JsonProperty(value="service_name")
        final String serviceName;
        @JsonProperty(value="component_name")
        final String componentName;

        ServiceComponentDetail(String serviceName, String componentName) {
            this.serviceName = serviceName;
            this.componentName = componentName;
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.componentName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceComponentDetail other = (ServiceComponentDetail)obj;
            return Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.componentName, other.componentName);
        }

        @Override
        public int compareTo(ServiceComponentDetail other) {
            return Comparator.comparing(detail -> detail.serviceName).thenComparing(detail -> detail.componentName).compare(this, other);
        }
    }

    static class ServiceDetail
    implements Comparable<ServiceDetail> {
        @JsonProperty(value="service_name")
        final String serviceName;

        ServiceDetail(String serviceName) {
            this.serviceName = serviceName;
        }

        public int hashCode() {
            return Objects.hash(this.serviceName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceDetail other = (ServiceDetail)obj;
            return Objects.equals(this.serviceName, other.serviceName);
        }

        @Override
        public int compareTo(ServiceDetail other) {
            return this.serviceName.compareTo(other.serviceName);
        }
    }
}

