/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.CONFIGURATION_WARNING, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class AutoStartDisabledCheck
extends ClusterCheck {
    static final UpgradeCheckDescription AUTO_START_DISABLED = new UpgradeCheckDescription("AUTO_START_DISABLED", UpgradeCheckType.CLUSTER, "Auto-Start Disabled Check", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"Auto Start must be disabled before performing an Upgrade. To disable Auto Start, navigate to Admin > Service Auto Start. Turn the toggle switch off to Disabled and hit Save.").build());
    static final String CLUSTER_ENV_TYPE = "cluster-env";
    static final String RECOVERY_ENABLED_KEY = "recovery_enabled";
    static final String RECOVERY_TYPE_KEY = "recovery_type";
    static final String RECOVERY_AUTO_START = "AUTO_START";

    public AutoStartDisabledCheck() {
        super(AUTO_START_DISABLED);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this, UpgradeCheckStatus.PASS);
        String autoStartEnabled = this.getProperty(request, CLUSTER_ENV_TYPE, RECOVERY_ENABLED_KEY);
        if (!Boolean.valueOf(autoStartEnabled).booleanValue()) {
            return result;
        }
        String recoveryType = this.getProperty(request, CLUSTER_ENV_TYPE, RECOVERY_TYPE_KEY);
        if (StringUtils.equals((String)recoveryType, (String)RECOVERY_AUTO_START)) {
            result.setFailReason(this.getFailReason(result, request));
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.getFailedOn().add(request.getClusterInformation().getClusterName());
        }
        return result;
    }
}

