/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.REPOSITORY_VERSION)
public class AmbariMetricsHadoopSinkVersionCompatibilityCheck
extends ClusterCheck {
    @Inject
    private RequestDAO requestDAO;
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    private static final Logger LOG = LoggerFactory.getLogger(AmbariMetricsHadoopSinkVersionCompatibilityCheck.class);
    static final String HADOOP_SINK_VERSION_NOT_SPECIFIED = "hadoop-sink-version-not-specified";
    static final String MIN_HADOOP_SINK_VERSION_PROPERTY_NAME = "min-hadoop-sink-version";
    static final String RETRY_INTERVAL_PROPERTY_NAME = "request-status-check-retry-interval";
    static final String NUM_TRIES_PROPERTY_NAME = "request-status-check-num-retries";
    private long retryInterval = 6000L;
    private int numTries = 20;
    static final UpgradeCheckDescription AMS_HADOOP_SINK_VERSION_COMPATIBILITY = new UpgradeCheckDescription("AMS_HADOOP_SINK_VERSION_COMPATIBILITY", UpgradeCheckType.HOST, "Ambari Metrics Hadoop Sinks need to be compatible with the stack version. This check ensures that compatibility.", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"Hadoop Sink version check failed. To fix this, please upgrade 'ambari-metrics-hadoop-sink' package to %s on all the failed hosts").put((Object)"hadoop-sink-version-not-specified", (Object)"Hadoop Sink version for pre-check not specified. Please use 'min-hadoop-sink-version' property in upgrade pack to specify min hadoop sink version").build());

    public AmbariMetricsHadoopSinkVersionCompatibilityCheck() {
        super(AMS_HADOOP_SINK_VERSION_COMPATIBILITY);
    }

    @Override
    public Set<String> getApplicableServices() {
        return Sets.newHashSet((Object[])new String[]{"AMBARI_METRICS", "HDFS"});
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest prereqCheckRequest) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String minHadoopSinkVersion = null;
        Map checkProperties = prereqCheckRequest.getCheckConfigurations();
        if (checkProperties != null) {
            minHadoopSinkVersion = (String)checkProperties.get(MIN_HADOOP_SINK_VERSION_PROPERTY_NAME);
            this.retryInterval = Long.parseLong(checkProperties.getOrDefault(RETRY_INTERVAL_PROPERTY_NAME, "6000"));
            this.numTries = Integer.parseInt(checkProperties.getOrDefault(NUM_TRIES_PROPERTY_NAME, "20"));
        }
        if (StringUtils.isEmpty(minHadoopSinkVersion)) {
            LOG.debug("Hadoop Sink version for pre-check not specified.");
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(this.getFailReason(HADOOP_SINK_VERSION_NOT_SPECIFIED, result, prereqCheckRequest));
            return result;
        }
        LOG.debug("Properties : Hadoop Sink Version = {} , retryInterval = {}, numTries = {}", new Object[]{minHadoopSinkVersion, this.retryInterval, this.numTries});
        OBDPManagementController ambariManagementController = OBDPServer.getController();
        ResourceProvider provider = AbstractControllerResourceProvider.getResourceProvider(Resource.Type.Request, ambariManagementController);
        String clusterName = prereqCheckRequest.getClusterName();
        Set<String> hosts = ambariManagementController.getClusters().getCluster(clusterName).getHosts("AMBARI_METRICS", "METRICS_MONITOR");
        if (CollectionUtils.isEmpty(hosts)) {
            LOG.warn("No hosts have the component METRICS_MONITOR.");
            result.setStatus(UpgradeCheckStatus.PASS);
            return result;
        }
        HashSet<Map<String, Object>> propertiesSet = new HashSet<Map<String, Object>>();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("Requests/cluster_name", clusterName);
        HashSet filterSet = new HashSet();
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("service_name", "AMBARI_METRICS");
        filterMap.put("component_name", "METRICS_MONITOR");
        filterMap.put("hosts", StringUtils.join(hosts, (String)","));
        filterSet.add(filterMap);
        properties.put("Requests/resource_filters", filterSet);
        propertiesSet.add(properties);
        HashMap<String, String> requestInfoProperties = new HashMap<String, String>();
        requestInfoProperties.put("command", "CHECK_HADOOP_SINK_VERSION");
        requestInfoProperties.put("context", "Pre Upgrade check for Hadoop Metric Sink version");
        Request request = PropertyHelper.getCreateRequest(propertiesSet, requestInfoProperties);
        try {
            PreUpgradeCheckStatus status;
            RequestStatus response = provider.createResources(request);
            Resource responseResource = response.getRequestResource();
            String requestIdProp = PropertyHelper.getPropertyId("Requests", "id");
            long requestId = (Long)responseResource.getPropertyValue(requestIdProp);
            LOG.debug("RequestId for AMS Hadoop Sink version compatibility pre check : " + requestId);
            Thread.sleep(this.retryInterval);
            int retry = 0;
            LinkedHashSet<String> failedHosts = new LinkedHashSet<String>();
            while ((status = this.pollRequestStatus(requestId, failedHosts)).equals((Object)PreUpgradeCheckStatus.RUNNING) && retry++ < this.numTries) {
                if (retry == this.numTries) continue;
                Thread.sleep(this.retryInterval);
            }
            if (status.equals((Object)PreUpgradeCheckStatus.SUCCESS)) {
                result.setStatus(UpgradeCheckStatus.PASS);
            } else {
                result.setStatus(UpgradeCheckStatus.FAIL);
                result.setFailReason(String.format(this.getFailReason(result, prereqCheckRequest), minHadoopSinkVersion));
                result.setFailedOn(failedHosts);
            }
        }
        catch (Exception e) {
            LOG.error("Error running Pre Upgrade check for AMS Hadoop Sink compatibility. " + e);
            result.setStatus(UpgradeCheckStatus.FAIL);
        }
        return result;
    }

    private PreUpgradeCheckStatus pollRequestStatus(long requestId, Set<String> failedHosts) throws Exception {
        List<RequestEntity> requestEntities = this.requestDAO.findByPks(Collections.singleton(requestId), true);
        if (requestEntities != null && requestEntities.size() > 0) {
            RequestEntity requestEntity = requestEntities.iterator().next();
            HostRoleStatus requestStatus = requestEntity.getStatus();
            if (HostRoleStatus.COMPLETED.equals((Object)requestStatus)) {
                return PreUpgradeCheckStatus.SUCCESS;
            }
            if (requestStatus.isFailedState()) {
                failedHosts.addAll(this.getPreUpgradeCheckFailedHosts(requestEntity));
                LOG.debug("Hadoop Sink version check failed on the following hosts : " + failedHosts.stream().collect(Collectors.joining(",")));
                return PreUpgradeCheckStatus.FAILED;
            }
            return PreUpgradeCheckStatus.RUNNING;
        }
        LOG.error("Unable to find RequestEntity for created request.");
        return PreUpgradeCheckStatus.FAILED;
    }

    private Set<String> getPreUpgradeCheckFailedHosts(RequestEntity requestEntity) throws Exception {
        List<HostRoleCommandEntity> hostRoleCommandEntities = this.hostRoleCommandDAO.findByRequest(requestEntity.getRequestId(), true);
        LinkedHashSet<String> failedHosts = new LinkedHashSet<String>();
        for (HostRoleCommandEntity hostRoleCommandEntity : hostRoleCommandEntities) {
            HostRoleStatus status = hostRoleCommandEntity.getStatus();
            if (!status.isFailedState()) continue;
            failedHosts.add(hostRoleCommandEntity.getHostName() + "(" + status + ")");
        }
        return failedHosts;
    }

    private static enum PreUpgradeCheckStatus {
        SUCCESS,
        FAILED,
        RUNNING;

    }
}

