/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.bootstrap;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.bootstrap.BSHostStatus;
import id.onyx.obdp.server.bootstrap.BSResponse;
import id.onyx.obdp.server.bootstrap.BSRunner;
import id.onyx.obdp.server.bootstrap.BootStrapStatus;
import id.onyx.obdp.server.bootstrap.FifoLinkedHashMap;
import id.onyx.obdp.server.bootstrap.SshHostInfo;
import id.onyx.obdp.server.configuration.Configuration;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BootStrapImpl {
    private File bootStrapDir;
    private String bootScript;
    private String bootSetupAgentScript;
    private String bootSetupAgentPassword;
    private BSRunner bsRunner;
    private String masterHostname;
    long timeout;
    private static final Logger LOG = LoggerFactory.getLogger(BootStrapImpl.class);
    int requestId = 0;
    private FifoLinkedHashMap<Long, BootStrapStatus> bsStatus;
    private final String clusterOsType;
    private final String clusterOsFamily;
    private String projectVersion;
    private int serverPort;

    @Inject
    public BootStrapImpl(Configuration conf, OBDPMetaInfo obdpMetaInfo) throws IOException {
        this.bootStrapDir = conf.getBootStrapDir();
        this.bootScript = conf.getBootStrapScript();
        this.bootSetupAgentScript = conf.getBootSetupAgentScript();
        this.bootSetupAgentPassword = conf.getBootSetupAgentPassword();
        this.bsStatus = new FifoLinkedHashMap();
        this.masterHostname = conf.getMasterHostname(InetAddress.getLocalHost().getCanonicalHostName());
        this.clusterOsType = conf.getServerOsType();
        this.clusterOsFamily = conf.getServerOsFamily();
        this.projectVersion = obdpMetaInfo.getServerVersion();
        this.projectVersion = this.projectVersion.equals("${ambariVersion}") ? "${ambariVersion}".replace("$", "") : this.projectVersion;
        this.serverPort = conf.getApiSSLAuthentication() ? conf.getClientSSLApiPort() : conf.getClientApiPort();
    }

    public synchronized BootStrapStatus getStatus(long requestId) {
        if (!this.bsStatus.containsKey(requestId)) {
            return null;
        }
        return (BootStrapStatus)this.bsStatus.get(requestId);
    }

    synchronized void updateStatus(long requestId, BootStrapStatus status) {
        this.bsStatus.put(requestId, status);
    }

    public synchronized void init() throws IOException {
        boolean mkdirs;
        if (!this.bootStrapDir.exists() && !(mkdirs = this.bootStrapDir.mkdirs())) {
            throw new IOException("Unable to make directory for bootstrap " + this.bootStrapDir);
        }
    }

    public synchronized BSResponse runBootStrap(SshHostInfo info) {
        BSResponse response = new BSResponse();
        LOG.info("BootStrapping hosts " + info.hostListAsString());
        if (this.bsRunner != null) {
            response.setLog("BootStrap in Progress: Cannot Run more than one.");
            response.setStatus(BSResponse.BSRunStat.ERROR);
            return response;
        }
        ++this.requestId;
        if (info.getHosts() == null || info.getHosts().isEmpty()) {
            BootStrapStatus status = new BootStrapStatus();
            status.setLog("Host list is empty.");
            status.setHostsStatus(new ArrayList<BSHostStatus>());
            status.setStatus(BootStrapStatus.BSStat.ERROR);
            this.updateStatus(this.requestId, status);
            response.setStatus(BSResponse.BSRunStat.OK);
            response.setLog("Host list is empty.");
            response.setRequestId(this.requestId);
            return response;
        }
        this.bsRunner = new BSRunner(this, info, this.bootStrapDir.toString(), this.bootScript, this.bootSetupAgentScript, this.bootSetupAgentPassword, this.requestId, 0L, this.masterHostname, info.isVerbose(), this.clusterOsFamily, this.projectVersion, this.serverPort);
        this.bsRunner.start();
        response.setStatus(BSResponse.BSRunStat.OK);
        response.setLog("Running Bootstrap now.");
        response.setRequestId(this.requestId);
        return response;
    }

    public synchronized List<BSHostStatus> getHostInfo(List<String> hosts) {
        ArrayList<BSHostStatus> statuses = new ArrayList<BSHostStatus>();
        if (null == hosts || 0 == hosts.size() || hosts.size() == 1 && hosts.get(0).equals("*")) {
            for (BootStrapStatus status : this.bsStatus.values()) {
                if (null == status.getHostsStatus()) continue;
                statuses.addAll(status.getHostsStatus());
            }
        } else {
            for (BootStrapStatus status : this.bsStatus.values()) {
                for (BSHostStatus hostStatus : status.getHostsStatus()) {
                    if (-1 == hosts.indexOf(hostStatus.getHostName())) continue;
                    statuses.add(hostStatus);
                }
            }
        }
        return statuses;
    }

    public synchronized void reset() {
        this.bsRunner = null;
    }
}

