/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.bootstrap;

import id.onyx.obdp.server.bootstrap.BSHostStatus;
import id.onyx.obdp.server.bootstrap.BSHostStatusCollector;
import id.onyx.obdp.server.bootstrap.BootStrapImpl;
import id.onyx.obdp.server.bootstrap.BootStrapStatus;
import id.onyx.obdp.server.bootstrap.SshHostInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BSRunner
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(BSRunner.class);
    private static final String DEFAULT_USER = "root";
    private static final String DEFAULT_SSHPORT = "22";
    private boolean finished = false;
    private SshHostInfo sshHostInfo;
    private File bootDir;
    private String bsScript;
    private File requestIdDir;
    private File sshKeyFile;
    private File passwordFile;
    private int requestId;
    private String agentSetupScript;
    private String agentSetupPassword;
    private String ambariHostname;
    private boolean verbose;
    private BootStrapImpl bsImpl;
    private final String clusterOsFamily;
    private String projectVersion;
    private int serverPort;

    public BSRunner(BootStrapImpl impl, SshHostInfo sshHostInfo, String bootDir, String bsScript, String agentSetupScript, String agentSetupPassword, int requestId, long timeout, String hostName, boolean isVerbose, String clusterOsFamily, String projectVersion, int serverPort) {
        this.requestId = requestId;
        this.sshHostInfo = sshHostInfo;
        this.bsScript = bsScript;
        this.bootDir = new File(bootDir);
        this.requestIdDir = new File(bootDir, Integer.toString(requestId));
        this.sshKeyFile = new File(this.requestIdDir, "sshKey");
        this.agentSetupScript = agentSetupScript;
        this.agentSetupPassword = agentSetupPassword;
        this.ambariHostname = hostName;
        this.verbose = isVerbose;
        this.clusterOsFamily = clusterOsFamily;
        this.projectVersion = projectVersion;
        this.bsImpl = impl;
        this.serverPort = serverPort;
        BootStrapStatus status = new BootStrapStatus();
        status.setLog("RUNNING");
        status.setStatus(BootStrapStatus.BSStat.RUNNING);
        this.bsImpl.updateStatus(requestId, status);
    }

    private String createHostString(List<String> list) {
        return list != null ? String.join((CharSequence)",", list) : "";
    }

    private void createRunDir() throws IOException {
        if (!this.bootDir.exists() && !this.bootDir.mkdirs()) {
            throw new IOException("Cannot create " + this.bootDir);
        }
        if (this.requestIdDir.exists()) {
            FileUtils.deleteDirectory((File)this.requestIdDir);
        }
        if (!this.requestIdDir.mkdirs()) {
            throw new IOException("Cannot create " + this.requestIdDir);
        }
    }

    private void writeSshKeyFile(String data) throws IOException {
        FileUtils.writeStringToFile((File)this.sshKeyFile, (String)data, (Charset)Charset.defaultCharset());
    }

    private void writePasswordFile(String data) throws IOException {
        FileUtils.writeStringToFile((File)this.passwordFile, (String)data, (Charset)Charset.defaultCharset());
    }

    private boolean waitForProcessTermination(Process process, long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                process.exitValue();
                return true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() - startTime < timeout) continue;
                return false;
            }
            break;
        }
    }

    private long calculateBSTimeout(int hostCount) {
        int PARALLEL_BS_COUNT = 20;
        long HOST_BS_TIMEOUT = 300000L;
        return Math.max(300000L, 300000L * (long)hostCount / 20L);
    }

    public synchronized void finished() {
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block64: {
            List<BSHostStatus> hostStatusList;
            Object scriptlog;
            BootStrapStatus.BSStat stat;
            block60: {
                block59: {
                    block58: {
                        Object password;
                        String sshPort;
                        String hostString = this.createHostString(this.sshHostInfo.getHosts());
                        long bootstrapTimeout = this.calculateBSTimeout(this.sshHostInfo.getHosts().size());
                        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
                        BSStatusCollector statusCollector = new BSStatusCollector();
                        ScheduledFuture<?> handle = null;
                        LOG.info("Kicking off the scheduler for polling on logs in " + this.requestIdDir);
                        String user = this.sshHostInfo.getUser();
                        String userRunAs = this.sshHostInfo.getUserRunAs();
                        if (user == null || user.isEmpty()) {
                            user = DEFAULT_USER;
                        }
                        if ((sshPort = this.sshHostInfo.getSshPort()) == null || sshPort.isEmpty()) {
                            sshPort = DEFAULT_SSHPORT;
                        }
                        Object[] command = new String[13];
                        stat = BootStrapStatus.BSStat.RUNNING;
                        scriptlog = "";
                        this.createRunDir();
                        handle = scheduler.scheduleWithFixedDelay(statusCollector, 0L, 10L, TimeUnit.SECONDS);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Using ssh key=\"{}\"", (Object)this.sshHostInfo.getSshKey());
                        }
                        if ((password = this.sshHostInfo.getPassword()) != null && !((String)password).isEmpty()) {
                            this.passwordFile = new File(this.requestIdDir, "host_pass");
                            String lineSeparator = System.getProperty("line.separator");
                            password = (String)password + lineSeparator;
                            this.writePasswordFile((String)password);
                        }
                        this.writeSshKeyFile(this.sshHostInfo.getSshKey());
                        command[0] = this.bsScript;
                        command[1] = hostString;
                        command[2] = this.requestIdDir.toString();
                        command[3] = user;
                        command[4] = sshPort;
                        command[5] = this.sshKeyFile.toString();
                        command[6] = this.agentSetupScript.toString();
                        command[7] = this.ambariHostname;
                        command[8] = this.clusterOsFamily;
                        command[9] = this.projectVersion;
                        command[10] = "" + this.serverPort;
                        command[11] = userRunAs;
                        command[12] = this.passwordFile == null ? "null" : this.passwordFile.toString();
                        HashMap<String, String> envVariables = new HashMap<String, String>();
                        if (System.getProperty("os.name").contains("Windows")) {
                            String[] command2 = new String[command.length + 1];
                            command2[0] = "python";
                            System.arraycopy(command, 0, command2, 1, command.length);
                            command = command2;
                            Map<String, String> envVarsWin = System.getenv();
                            if (envVarsWin != null) {
                                envVariables.putAll(envVarsWin);
                            }
                        }
                        LOG.info("Host= " + hostString + " bs=" + this.bsScript + " requestDir=" + this.requestIdDir + " user=" + user + " sshPort=" + sshPort + " keyfile=" + this.sshKeyFile + " passwordFile " + this.passwordFile + " server=" + this.ambariHostname + " version=" + this.projectVersion + " serverPort=" + this.serverPort + " userRunAs=" + userRunAs + " timeout=" + bootstrapTimeout / 1000L);
                        envVariables.put("AMBARI_PASSPHRASE", this.agentSetupPassword);
                        if (this.verbose) {
                            envVariables.put("BS_VERBOSE", "\"-vvv\"");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(Arrays.toString(command));
                        }
                        String bootStrapOutputFilePath = this.requestIdDir + File.separator + "bootstrap.out";
                        String bootStrapErrorFilePath = this.requestIdDir + File.separator + "bootstrap.err";
                        ProcessBuilder pb = new ProcessBuilder((String[])command);
                        pb.redirectOutput(new File(bootStrapOutputFilePath));
                        pb.redirectError(new File(bootStrapErrorFilePath));
                        Map<String, String> env = pb.environment();
                        env.putAll(envVariables);
                        Process process = pb.start();
                        try {
                            long now;
                            String logInfoMessage = "Bootstrap output, log=" + bootStrapErrorFilePath + " " + (String)bootStrapOutputFilePath + " at " + this.ambariHostname;
                            LOG.info(logInfoMessage);
                            int exitCode = 1;
                            boolean timedOut = false;
                            if (this.waitForProcessTermination(process, bootstrapTimeout)) {
                                exitCode = process.exitValue();
                            } else {
                                LOG.warn("Bootstrap process timed out. It will be destroyed.");
                                process.destroy();
                                timedOut = true;
                            }
                            String outMesg = "";
                            String errMesg = "";
                            try {
                                outMesg = FileUtils.readFileToString((File)new File(bootStrapOutputFilePath), (Charset)Charset.defaultCharset());
                                errMesg = FileUtils.readFileToString((File)new File(bootStrapErrorFilePath), (Charset)Charset.defaultCharset());
                            }
                            catch (IOException io) {
                                LOG.info("Error in reading files ", (Throwable)io);
                            }
                            scriptlog = outMesg + "\n\n" + errMesg;
                            if (timedOut) {
                                scriptlog = (String)scriptlog + "\n\n Bootstrap process timed out. It was destroyed.";
                            }
                            LOG.info("Script log Mesg " + (String)scriptlog);
                            if (exitCode != 0) {
                                stat = BootStrapStatus.BSStat.ERROR;
                                this.interuptSetupAgent(99, (String)scriptlog);
                            } else {
                                stat = BootStrapStatus.BSStat.SUCCESS;
                            }
                            scheduler.schedule(new BSStatusCollector(), 0L, TimeUnit.SECONDS);
                            long startTime = System.currentTimeMillis();
                            do {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Waiting for hosts status to be updated");
                                }
                                boolean pendingHosts = false;
                                BootStrapStatus tmpStatus = this.bsImpl.getStatus(this.requestId);
                                List<BSHostStatus> hostStatusList2 = tmpStatus.getHostsStatus();
                                if (hostStatusList2 != null) {
                                    for (BSHostStatus status : hostStatusList2) {
                                        if (!status.getStatus().equals("RUNNING")) continue;
                                        pendingHosts = true;
                                    }
                                } else {
                                    pendingHosts = true;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Whether hosts status yet to be updated, pending={}", (Object)pendingHosts);
                                }
                                if (!pendingHosts) {
                                    break block58;
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while ((now = System.currentTimeMillis()) < startTime + 15000L);
                            LOG.warn("Gave up waiting for hosts status to be updated");
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e);
                        }
                        finally {
                            if (handle != null) {
                                handle.cancel(true);
                            }
                            scheduler.schedule(new BSStatusCollector(), 0L, TimeUnit.SECONDS);
                            scheduler.shutdownNow();
                            try {
                                scheduler.awaitTermination(10L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                LOG.info("Interruped while waiting for scheduler");
                            }
                            process.destroy();
                        }
                    }
                    BootStrapStatus tmpStatus = this.bsImpl.getStatus(this.requestId);
                    hostStatusList = tmpStatus.getHostsStatus();
                    if (hostStatusList == null) break block59;
                    for (BSHostStatus hostStatus : hostStatusList) {
                        if (!"FAILED".equals(hostStatus.getStatus())) continue;
                        stat = BootStrapStatus.BSStat.ERROR;
                        break block60;
                    }
                    break block60;
                }
                stat = BootStrapStatus.BSStat.ERROR;
            }
            BootStrapStatus newStat = new BootStrapStatus();
            newStat.setHostsStatus(hostStatusList);
            newStat.setLog((String)scriptlog);
            newStat.setStatus(stat);
            try {
                FileUtils.forceDelete((File)this.sshKeyFile);
            }
            catch (IOException io) {
                LOG.warn(io.getMessage());
            }
            if (this.passwordFile != null) {
                try {
                    FileUtils.forceDelete((File)this.passwordFile);
                }
                catch (IOException io) {
                    LOG.warn(io.getMessage());
                }
            }
            this.bsImpl.updateStatus(this.requestId, newStat);
            this.bsImpl.reset();
            this.finished();
            break block64;
            catch (IOException io) {
                block62: {
                    block61: {
                        LOG.info("Error executing bootstrap " + io.getMessage());
                        stat = BootStrapStatus.BSStat.ERROR;
                        this.interuptSetupAgent(99, io.getMessage());
                        BootStrapStatus tmpStatus = this.bsImpl.getStatus(this.requestId);
                        hostStatusList = tmpStatus.getHostsStatus();
                        if (hostStatusList == null) break block61;
                        for (BSHostStatus hostStatus : hostStatusList) {
                            if (!"FAILED".equals(hostStatus.getStatus())) continue;
                            stat = BootStrapStatus.BSStat.ERROR;
                            break block62;
                        }
                        break block62;
                    }
                    stat = BootStrapStatus.BSStat.ERROR;
                }
                newStat = new BootStrapStatus();
                newStat.setHostsStatus(hostStatusList);
                newStat.setLog((String)scriptlog);
                newStat.setStatus(stat);
                try {
                    FileUtils.forceDelete((File)this.sshKeyFile);
                }
                catch (IOException io2) {
                    LOG.warn(io2.getMessage());
                }
                if (this.passwordFile != null) {
                    try {
                        FileUtils.forceDelete((File)this.passwordFile);
                    }
                    catch (IOException io3) {
                        LOG.warn(io3.getMessage());
                    }
                }
                this.bsImpl.updateStatus(this.requestId, newStat);
                this.bsImpl.reset();
                this.finished();
                catch (Throwable throwable) {
                    BootStrapStatus tmpStatus = this.bsImpl.getStatus(this.requestId);
                    List<BSHostStatus> hostStatusList3 = tmpStatus.getHostsStatus();
                    if (hostStatusList3 != null) {
                        for (BSHostStatus hostStatus : hostStatusList3) {
                            if (!"FAILED".equals(hostStatus.getStatus())) continue;
                            stat = BootStrapStatus.BSStat.ERROR;
                            break;
                        }
                    } else {
                        stat = BootStrapStatus.BSStat.ERROR;
                    }
                    BootStrapStatus newStat2 = new BootStrapStatus();
                    newStat2.setHostsStatus(hostStatusList3);
                    newStat2.setLog((String)scriptlog);
                    newStat2.setStatus(stat);
                    try {
                        FileUtils.forceDelete((File)this.sshKeyFile);
                    }
                    catch (IOException io4) {
                        LOG.warn(io4.getMessage());
                    }
                    if (this.passwordFile != null) {
                        try {
                            FileUtils.forceDelete((File)this.passwordFile);
                        }
                        catch (IOException io5) {
                            LOG.warn(io5.getMessage());
                        }
                    }
                    this.bsImpl.updateStatus(this.requestId, newStat2);
                    this.bsImpl.reset();
                    this.finished();
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void interuptSetupAgent(int exitCode, String errMesg) {
        PrintWriter setupAgentDoneWriter = null;
        PrintWriter setupAgentLogWriter = null;
        try {
            for (String host : this.sshHostInfo.getHosts()) {
                File logFile;
                File doneFile = new File(this.requestIdDir, host + ".done");
                if (!doneFile.exists()) {
                    setupAgentDoneWriter = new PrintWriter(doneFile);
                    setupAgentDoneWriter.print(exitCode);
                    setupAgentDoneWriter.close();
                }
                if ((logFile = new File(this.requestIdDir, host + ".log")).exists()) continue;
                setupAgentLogWriter = new PrintWriter(logFile);
                setupAgentLogWriter.print("Error while bootstrapping:\n" + errMesg);
                setupAgentLogWriter.close();
            }
        }
        catch (FileNotFoundException ex) {
            LOG.error(ex.toString());
        }
        finally {
            if (setupAgentDoneWriter != null) {
                setupAgentDoneWriter.close();
            }
            if (setupAgentLogWriter != null) {
                setupAgentLogWriter.close();
            }
        }
    }

    public synchronized boolean isRunning() {
        return !this.finished;
    }

    private class BSStatusCollector
    implements Runnable {
        private BSStatusCollector() {
        }

        @Override
        public void run() {
            BSHostStatusCollector collector = new BSHostStatusCollector(BSRunner.this.requestIdDir, BSRunner.this.sshHostInfo.getHosts());
            collector.run();
            List<BSHostStatus> hostStatus = collector.getHostStatus();
            BootStrapStatus status = new BootStrapStatus();
            status.setHostsStatus(hostStatus);
            status.setLog("");
            status.setStatus(BootStrapStatus.BSStat.RUNNING);
            BSRunner.this.bsImpl.updateStatus(BSRunner.this.requestId, status);
        }
    }
}

