/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.bootstrap;

import id.onyx.obdp.server.bootstrap.BSHostStatus;
import id.onyx.obdp.server.utils.Closeables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BSHostStatusCollector {
    private File requestIdDir;
    private List<BSHostStatus> hostStatus;
    public static final String logFileFilter = ".log";
    public static final String doneFileFilter = ".done";
    private static final Logger LOG = LoggerFactory.getLogger(BSHostStatusCollector.class);
    private List<String> hosts;

    public BSHostStatusCollector(File requestIdDir, List<String> hosts) {
        this.requestIdDir = requestIdDir;
        this.hosts = hosts;
    }

    public List<BSHostStatus> getHostStatus() {
        return this.hostStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.info("Request directory " + this.requestIdDir);
        this.hostStatus = new ArrayList<BSHostStatus>();
        if (this.hosts == null) {
            return;
        }
        LOG.info("HostList for polling on " + this.hosts);
        for (String host : this.hosts) {
            BSHostStatus status = new BSHostStatus();
            status.setHostName(host);
            File done = new File(this.requestIdDir, host + doneFileFilter);
            File log = new File(this.requestIdDir, host + logFileFilter);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Polling bootstrap status for host, requestDir={}, host={}, doneFileExists={}, logFileExists={}", new Object[]{this.requestIdDir, host, done.exists(), log.exists()});
            }
            if (!done.exists()) {
                status.setStatus("RUNNING");
            } else {
                status.setStatus("FAILED");
                try {
                    String statusCode = FileUtils.readFileToString((File)done, (Charset)Charset.defaultCharset()).trim();
                    if (statusCode.equals("0")) {
                        status.setStatus("DONE");
                    }
                    this.updateStatus(status, statusCode);
                }
                catch (IOException e) {
                    LOG.info("Error reading done file " + done);
                }
            }
            if (!log.exists()) {
                status.setLog("");
            } else {
                String logString = "";
                BufferedReader reader = null;
                try {
                    StringBuilder sb = new StringBuilder();
                    reader = new BufferedReader(new FileReader(log));
                    String line = null;
                    while (null != (line = reader.readLine())) {
                        if (line.startsWith("tcgetattr:") || line.startsWith("tput:")) continue;
                        if (0 != sb.length() || 0 == line.length()) {
                            sb.append('\n');
                        }
                        if (-1 != line.indexOf("\\n")) {
                            sb.append(line.replace("\\n", "\n"));
                            continue;
                        }
                        sb.append(line);
                    }
                    logString = sb.toString();
                    Closeables.closeSilently(reader);
                }
                catch (IOException e) {
                    LOG.info("Error reading log file " + log + ". Log file may be have not created yet");
                }
                finally {
                    Closeables.closeSilently(reader);
                }
                status.setLog(logString);
            }
            this.hostStatus.add(status);
        }
    }

    private void updateStatus(BSHostStatus status, String statusCode) {
        status.setStatusCode(statusCode);
        int reason = -1;
        try {
            reason = Integer.parseInt(statusCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (reason) {
            case 2: {
                status.setStatusAction("Processing could not continue because the file was not found.");
                break;
            }
            default: {
                if (null == status.getLog()) break;
                String lowerLog = status.getLog().toLowerCase();
                if (-1 != lowerLog.indexOf("permission denied") && -1 != lowerLog.indexOf("publickey")) {
                    status.setStatusAction("Use correct SSH key");
                    break;
                }
                if (-1 == lowerLog.indexOf("connect to host")) break;
                status.setStatusAction("Please verify that the hostname '" + status.getHostName() + "' is correct.");
            }
        }
    }
}

