/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.ViewPrivilegeChangeRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.PrincipalTypeEntity;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewPrivilegeEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object)Request.Type.PUT).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.ViewPrivilege).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        Map<String, List<String>> users = this.getEntities(request, PrincipalTypeEntity.USER_PRINCIPAL_TYPE_NAME);
        Map<String, List<String>> groups = this.getEntities(request, PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME);
        Map<String, List<String>> roles = this.getEntities(request, PrincipalTypeEntity.ROLE_PRINCIPAL_TYPE_NAME);
        return ((ViewPrivilegeChangeRequestAuditEvent.ViewPrivilegeChangeRequestAuditEventBuilder)((ViewPrivilegeChangeRequestAuditEvent.ViewPrivilegeChangeRequestAuditEventBuilder)((ViewPrivilegeChangeRequestAuditEvent.ViewPrivilegeChangeRequestAuditEventBuilder)((ViewPrivilegeChangeRequestAuditEvent.ViewPrivilegeChangeRequestAuditEventBuilder)((ViewPrivilegeChangeRequestAuditEvent.ViewPrivilegeChangeRequestAuditEventBuilder)ViewPrivilegeChangeRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withType(RequestAuditEventCreatorHelper.getProperty(request, "PrivilegeInfo/view_name")).withVersion(RequestAuditEventCreatorHelper.getProperty(request, "PrivilegeInfo/version")).withName(RequestAuditEventCreatorHelper.getProperty(request, "PrivilegeInfo/instance_name")).withUsers(users).withGroups(groups).withRoles(roles).build();
    }

    private Map<String, List<String>> getEntities(Request request, String type) {
        HashMap<String, List<String>> entities = new HashMap<String, List<String>>();
        for (Map<String, Object> propertyMap : request.getBody().getPropertySets()) {
            String ptype = String.valueOf(propertyMap.get("PrivilegeInfo/principal_type"));
            if (!type.equals(ptype)) continue;
            String role = String.valueOf(propertyMap.get("PrivilegeInfo/permission_name"));
            String name = String.valueOf(propertyMap.get("PrivilegeInfo/principal_name"));
            if (!entities.containsKey(role)) {
                entities.put(role, new LinkedList());
            }
            ((List)entities.get(role)).add(name);
        }
        return entities;
    }
}

