/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.AddViewInstanceRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.ChangeViewInstanceRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.DeleteViewInstanceRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Set;

public class ViewInstanceEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.ViewInstance).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        switch (request.getRequestType()) {
            case POST: {
                return ((AddViewInstanceRequestAuditEvent.AddViewInstanceRequestAuditEventBuilder)((AddViewInstanceRequestAuditEvent.AddViewInstanceRequestAuditEventBuilder)((AddViewInstanceRequestAuditEvent.AddViewInstanceRequestAuditEventBuilder)((AddViewInstanceRequestAuditEvent.AddViewInstanceRequestAuditEventBuilder)((AddViewInstanceRequestAuditEvent.AddViewInstanceRequestAuditEventBuilder)AddViewInstanceRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withType(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/view_name")).withVersion(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/version")).withName(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/instance_name")).withDisplayName(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/label")).withDescription(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/description")).build();
            }
            case PUT: {
                return ((ChangeViewInstanceRequestAuditEvent.ChangeViewInstanceRequestAuditEventBuilder)((ChangeViewInstanceRequestAuditEvent.ChangeViewInstanceRequestAuditEventBuilder)((ChangeViewInstanceRequestAuditEvent.ChangeViewInstanceRequestAuditEventBuilder)((ChangeViewInstanceRequestAuditEvent.ChangeViewInstanceRequestAuditEventBuilder)((ChangeViewInstanceRequestAuditEvent.ChangeViewInstanceRequestAuditEventBuilder)ChangeViewInstanceRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withType(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/view_name")).withVersion(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/version")).withName(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/instance_name")).withDisplayName(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/label")).withDescription(RequestAuditEventCreatorHelper.getProperty(request, "ViewInstanceInfo/description")).build();
            }
            case DELETE: {
                return ((DeleteViewInstanceRequestAuditEvent.DeleteViewInstanceRequestAuditEventBuilder)((DeleteViewInstanceRequestAuditEvent.DeleteViewInstanceRequestAuditEventBuilder)((DeleteViewInstanceRequestAuditEvent.DeleteViewInstanceRequestAuditEventBuilder)((DeleteViewInstanceRequestAuditEvent.DeleteViewInstanceRequestAuditEventBuilder)((DeleteViewInstanceRequestAuditEvent.DeleteViewInstanceRequestAuditEventBuilder)DeleteViewInstanceRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withType(request.getResource().getKeyValueMap().get(Resource.Type.View)).withVersion(request.getResource().getKeyValueMap().get(Resource.Type.ViewVersion)).withName(request.getResource().getKeyValueMap().get(Resource.Type.ViewInstance)).build();
            }
        }
        return null;
    }
}

