/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.ActivateUserRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.AdminUserRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.CreateUserRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.DeleteUserRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.UserPasswordChangeRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Map;
import java.util.Set;

public class UserEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.User).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        switch (request.getRequestType()) {
            case POST: {
                return ((CreateUserRequestAuditEvent.CreateUserRequestAuditEventBuilder)((CreateUserRequestAuditEvent.CreateUserRequestAuditEventBuilder)((CreateUserRequestAuditEvent.CreateUserRequestAuditEventBuilder)((CreateUserRequestAuditEvent.CreateUserRequestAuditEventBuilder)((CreateUserRequestAuditEvent.CreateUserRequestAuditEventBuilder)CreateUserRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withCreatedUsername(this.getUsername(request)).withActive(this.isActive(request)).withAdmin(this.isAdmin(request)).build();
            }
            case DELETE: {
                return ((DeleteUserRequestAuditEvent.DeleteUserRequestAuditEventBuilder)((DeleteUserRequestAuditEvent.DeleteUserRequestAuditEventBuilder)((DeleteUserRequestAuditEvent.DeleteUserRequestAuditEventBuilder)((DeleteUserRequestAuditEvent.DeleteUserRequestAuditEventBuilder)((DeleteUserRequestAuditEvent.DeleteUserRequestAuditEventBuilder)DeleteUserRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withDeletedUsername(request.getResource().getKeyValueMap().get(Resource.Type.User)).build();
            }
            case PUT: {
                if (this.hasActive(request)) {
                    return ((ActivateUserRequestAuditEvent.ActivateUserRequestAuditEventBuilder)((ActivateUserRequestAuditEvent.ActivateUserRequestAuditEventBuilder)((ActivateUserRequestAuditEvent.ActivateUserRequestAuditEventBuilder)((ActivateUserRequestAuditEvent.ActivateUserRequestAuditEventBuilder)((ActivateUserRequestAuditEvent.ActivateUserRequestAuditEventBuilder)ActivateUserRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withAffectedUsername(this.getUsername(request)).withActive(this.isActive(request)).build();
                }
                if (this.hasAdmin(request)) {
                    return ((AdminUserRequestAuditEvent.AdminUserRequestAuditEventBuilder)((AdminUserRequestAuditEvent.AdminUserRequestAuditEventBuilder)((AdminUserRequestAuditEvent.AdminUserRequestAuditEventBuilder)((AdminUserRequestAuditEvent.AdminUserRequestAuditEventBuilder)((AdminUserRequestAuditEvent.AdminUserRequestAuditEventBuilder)AdminUserRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withAffectedUsername(this.getUsername(request)).withAdmin(this.isAdmin(request)).build();
                }
                if (!this.hasOldPassword(request)) break;
                return ((UserPasswordChangeRequestAuditEvent.UserPasswordChangeRequestAuditEventBuilder)((UserPasswordChangeRequestAuditEvent.UserPasswordChangeRequestAuditEventBuilder)((UserPasswordChangeRequestAuditEvent.UserPasswordChangeRequestAuditEventBuilder)((UserPasswordChangeRequestAuditEvent.UserPasswordChangeRequestAuditEventBuilder)((UserPasswordChangeRequestAuditEvent.UserPasswordChangeRequestAuditEventBuilder)UserPasswordChangeRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withAffectedUsername(this.getUsername(request)).build();
            }
        }
        return null;
    }

    private boolean isAdmin(Request request) {
        return this.hasAdmin(request) && "true".equals(RequestAuditEventCreatorHelper.getProperty(request, "Users/admin"));
    }

    private boolean isActive(Request request) {
        return this.hasActive(request) && "true".equals(RequestAuditEventCreatorHelper.getProperty(request, "Users/active"));
    }

    private boolean hasAdmin(Request request) {
        Map first = (Map)Iterables.getFirst(request.getBody().getPropertySets(), null);
        return first != null && first.containsKey("Users/admin");
    }

    private boolean hasActive(Request request) {
        Map first = (Map)Iterables.getFirst(request.getBody().getPropertySets(), null);
        return first != null && first.containsKey("Users/active");
    }

    private boolean hasOldPassword(Request request) {
        Map first = (Map)Iterables.getFirst(request.getBody().getPropertySets(), null);
        return first != null && first.containsKey("Users/old_password");
    }

    private String getUsername(Request request) {
        Map first = (Map)Iterables.getFirst(request.getBody().getPropertySets(), null);
        if (first != null) {
            return String.valueOf(first.get("Users/user_name"));
        }
        return null;
    }
}

