/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.DeleteServiceRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.StartOperationRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.controller.internal.ServiceResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Map;
import java.util.Set;

public class ServiceEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.Service).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        if (request.getRequestType() == Request.Type.DELETE) {
            return ((DeleteServiceRequestAuditEvent.DeleteServiceRequestAuditEventBuilder)((DeleteServiceRequestAuditEvent.DeleteServiceRequestAuditEventBuilder)((DeleteServiceRequestAuditEvent.DeleteServiceRequestAuditEventBuilder)((DeleteServiceRequestAuditEvent.DeleteServiceRequestAuditEventBuilder)((DeleteServiceRequestAuditEvent.DeleteServiceRequestAuditEventBuilder)DeleteServiceRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withService(request.getResource().getKeyValueMap().get(Resource.Type.Service)).build();
        }
        String operation = this.getOperation(request);
        Long requestId = null;
        if (this.containsRequestId(result)) {
            requestId = this.getRequestId(result);
        }
        StartOperationRequestAuditEvent.StartOperationAuditEventBuilder auditEventBuilder = ((StartOperationRequestAuditEvent.StartOperationAuditEventBuilder)((StartOperationRequestAuditEvent.StartOperationAuditEventBuilder)StartOperationRequestAuditEvent.builder().withOperation(operation).withRemoteIp(request.getRemoteAddress())).withTimestamp(System.currentTimeMillis())).withRequestId(String.valueOf(requestId));
        if (result.getStatus().isErrorState()) {
            auditEventBuilder.withReasonOfFailure(result.getStatus().getMessage());
        }
        return auditEventBuilder.build();
    }

    private String getOperation(Request request) {
        if (request.getBody().getRequestInfoProperties() != null && request.getBody().getRequestInfoProperties().containsKey("operation_level/level")) {
            Object operation = "";
            if ("CLUSTER".equals(request.getBody().getRequestInfoProperties().get("operation_level/level"))) {
                for (Map<String, Object> map : request.getBody().getPropertySets()) {
                    if (!map.containsKey(ServiceResourceProvider.SERVICE_SERVICE_STATE_PROPERTY_ID)) continue;
                    operation = String.valueOf(map.get(ServiceResourceProvider.SERVICE_SERVICE_STATE_PROPERTY_ID)) + ": all services (" + request.getBody().getRequestInfoProperties().get("operation_level/cluster_name") + ")";
                    break;
                }
            }
            if ("SERVICE".equals(request.getBody().getRequestInfoProperties().get("operation_level/level"))) {
                for (Map<String, Object> map : request.getBody().getPropertySets()) {
                    if (!map.containsKey(ServiceResourceProvider.SERVICE_SERVICE_STATE_PROPERTY_ID)) continue;
                    operation = String.valueOf(map.get(ServiceResourceProvider.SERVICE_SERVICE_STATE_PROPERTY_ID)) + ": " + map.get(ServiceResourceProvider.SERVICE_SERVICE_NAME_PROPERTY_ID) + " (" + request.getBody().getRequestInfoProperties().get("operation_level/cluster_name") + ")";
                    break;
                }
            }
            return operation;
        }
        for (Map<String, Object> map : request.getBody().getPropertySets()) {
            if (!map.containsKey(ServiceResourceProvider.SERVICE_MAINTENANCE_STATE_PROPERTY_ID)) continue;
            return "Turn " + map.get(ServiceResourceProvider.SERVICE_MAINTENANCE_STATE_PROPERTY_ID) + " Maintenance Mode for " + map.get(ServiceResourceProvider.SERVICE_SERVICE_NAME_PROPERTY_ID);
        }
        return null;
    }

    private Long getRequestId(Result result) {
        return (Long)result.getResultTree().getChild("request").getObject().getPropertiesMap().get("Requests").get("id");
    }

    private boolean containsRequestId(Result result) {
        return result.getResultTree().getChild("request") != null && result.getResultTree().getChild("request").getObject() != null && result.getResultTree().getChild("request").getObject().getPropertiesMap().get("Requests") != null && result.getResultTree().getChild("request").getObject().getPropertiesMap().get("Requests").get("id") != null;
    }
}

