/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.AddRequestRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Map;
import java.util.Set;

public class RequestEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object)Request.Type.POST).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.Request).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        switch (request.getRequestType()) {
            case POST: {
                return ((AddRequestRequestAuditEvent.AddRequestAuditEventBuilder)((AddRequestRequestAuditEvent.AddRequestAuditEventBuilder)((AddRequestRequestAuditEvent.AddRequestAuditEventBuilder)((AddRequestRequestAuditEvent.AddRequestAuditEventBuilder)((AddRequestRequestAuditEvent.AddRequestAuditEventBuilder)AddRequestRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withCommand(request.getBody().getRequestInfoProperties().get("command")).withClusterName(this.getClusterName(request, "operation_level/cluster_name")).build();
            }
        }
        return null;
    }

    private String getClusterName(Request request, String propertyName) {
        Map<String, String> requestInfoProps = request.getBody().getRequestInfoProperties();
        return requestInfoProps.containsKey(propertyName) ? requestInfoProps.get(propertyName) : this.getProperty(request, "Requests/cluster_name");
    }

    private String getProperty(Request request, String propertyName) {
        if (!request.getBody().getPropertySets().isEmpty()) {
            return String.valueOf(request.getBody().getPropertySets().iterator().next().get(propertyName));
        }
        return null;
    }
}

