/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.AddRepositoryVersionRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.ChangeRepositoryVersionRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.DeleteRepositoryVersionRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.internal.OperatingSystemResourceProvider;
import id.onyx.obdp.server.controller.internal.RepositoryResourceProvider;
import id.onyx.obdp.server.controller.internal.RepositoryVersionResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class RepositoryVersionEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.RepositoryVersion).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        switch (request.getRequestType()) {
            case POST: {
                return ((AddRepositoryVersionRequestAuditEvent.AddRepositoryVersionAuditEventBuilder)((AddRepositoryVersionRequestAuditEvent.AddRepositoryVersionAuditEventBuilder)((AddRepositoryVersionRequestAuditEvent.AddRepositoryVersionAuditEventBuilder)((AddRepositoryVersionRequestAuditEvent.AddRepositoryVersionAuditEventBuilder)((AddRepositoryVersionRequestAuditEvent.AddRepositoryVersionAuditEventBuilder)AddRepositoryVersionRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withStackName(RequestAuditEventCreatorHelper.getProperty(request, RepositoryVersionResourceProvider.REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID)).withStackVersion(RequestAuditEventCreatorHelper.getProperty(request, RepositoryVersionResourceProvider.REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID)).withDisplayName(RequestAuditEventCreatorHelper.getProperty(request, RepositoryVersionResourceProvider.REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID)).withRepoVersion(RequestAuditEventCreatorHelper.getProperty(request, RepositoryVersionResourceProvider.REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID)).withRepos(this.getRepos(request)).build();
            }
            case PUT: {
                return ((ChangeRepositoryVersionRequestAuditEvent.ChangeRepositoryVersionAuditEventBuilder)((ChangeRepositoryVersionRequestAuditEvent.ChangeRepositoryVersionAuditEventBuilder)((ChangeRepositoryVersionRequestAuditEvent.ChangeRepositoryVersionAuditEventBuilder)((ChangeRepositoryVersionRequestAuditEvent.ChangeRepositoryVersionAuditEventBuilder)((ChangeRepositoryVersionRequestAuditEvent.ChangeRepositoryVersionAuditEventBuilder)ChangeRepositoryVersionRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withStackName(RequestAuditEventCreatorHelper.getProperty(request, RepositoryVersionResourceProvider.REPOSITORY_VERSION_STACK_NAME_PROPERTY_ID)).withStackVersion(RequestAuditEventCreatorHelper.getProperty(request, RepositoryVersionResourceProvider.REPOSITORY_VERSION_STACK_VERSION_PROPERTY_ID)).withDisplayName(RequestAuditEventCreatorHelper.getProperty(request, RepositoryVersionResourceProvider.REPOSITORY_VERSION_DISPLAY_NAME_PROPERTY_ID)).withRepoVersion(RequestAuditEventCreatorHelper.getProperty(request, RepositoryVersionResourceProvider.REPOSITORY_VERSION_REPOSITORY_VERSION_PROPERTY_ID)).withRepos(this.getRepos(request)).build();
            }
            case DELETE: {
                return ((DeleteRepositoryVersionRequestAuditEvent.DeleteRepositoryVersionAuditEventBuilder)((DeleteRepositoryVersionRequestAuditEvent.DeleteRepositoryVersionAuditEventBuilder)((DeleteRepositoryVersionRequestAuditEvent.DeleteRepositoryVersionAuditEventBuilder)((DeleteRepositoryVersionRequestAuditEvent.DeleteRepositoryVersionAuditEventBuilder)((DeleteRepositoryVersionRequestAuditEvent.DeleteRepositoryVersionAuditEventBuilder)DeleteRepositoryVersionRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withStackName(request.getResource().getKeyValueMap().get(Resource.Type.Stack)).withStackVersion(request.getResource().getKeyValueMap().get(Resource.Type.StackVersion)).withRepoVersion(request.getResource().getKeyValueMap().get(Resource.Type.RepositoryVersion)).build();
            }
        }
        return null;
    }

    private SortedMap<String, List<Map<String, String>>> getRepos(Request request) {
        SortedMap<String, List<Map<String, String>>> result = new TreeMap<String, List<Map<String, String>>>();
        Map first = (Map)Iterables.getFirst(request.getBody().getPropertySets(), null);
        if (first != null && first.get("operating_systems") instanceof Set) {
            Set set = (Set)first.get("operating_systems");
            result = this.createResultForOperationSystems(set);
        }
        return result;
    }

    private SortedMap<String, List<Map<String, String>>> createResultForOperationSystems(Set<?> set) {
        TreeMap<String, List<Map<String, String>>> result = new TreeMap<String, List<Map<String, String>>>();
        for (Object entry : set) {
            if (!(entry instanceof Map)) continue;
            Map map = (Map)entry;
            String osType = (String)map.get(OperatingSystemResourceProvider.OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID);
            if (!result.containsKey(osType)) {
                result.put(osType, new LinkedList());
            }
            if (!(map.get("repositories") instanceof Set)) continue;
            Set repos = (Set)map.get("repositories");
            for (Object repo : repos) {
                if (!(repo instanceof Map)) continue;
                Map<String, String> resultMap = this.buildResultRepo((Map)repo);
                ((List)result.get(osType)).add(resultMap);
            }
        }
        return result;
    }

    private Map<String, String> buildResultRepo(Map<String, String> repo) {
        Map<String, String> m = repo;
        String repoId = m.get(RepositoryResourceProvider.REPOSITORY_REPO_ID_PROPERTY_ID);
        String repo_name = m.get(RepositoryResourceProvider.REPOSITORY_REPO_NAME_PROPERTY_ID);
        String baseUrl = m.get(RepositoryResourceProvider.REPOSITORY_BASE_URL_PROPERTY_ID);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("repo_id", repoId);
        resultMap.put("repo_name", repo_name);
        resultMap.put("base_url", baseUrl);
        return resultMap;
    }
}

