/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.ClusterPrivilegeChangeRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.PrivilegeChangeRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.PrincipalTypeEntity;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrivilegeEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.ClusterPrivilege).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        Map<String, List<String>> users = this.getEntities(request, PrincipalTypeEntity.USER_PRINCIPAL_TYPE_NAME);
        Map<String, List<String>> groups = this.getEntities(request, PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME);
        Map<String, List<String>> roles = this.getEntities(request, PrincipalTypeEntity.ROLE_PRINCIPAL_TYPE_NAME);
        switch (request.getRequestType()) {
            case PUT: {
                return ((ClusterPrivilegeChangeRequestAuditEvent.ClusterPrivilegeChangeRequestAuditEventBuilder)((ClusterPrivilegeChangeRequestAuditEvent.ClusterPrivilegeChangeRequestAuditEventBuilder)((ClusterPrivilegeChangeRequestAuditEvent.ClusterPrivilegeChangeRequestAuditEventBuilder)((ClusterPrivilegeChangeRequestAuditEvent.ClusterPrivilegeChangeRequestAuditEventBuilder)((ClusterPrivilegeChangeRequestAuditEvent.ClusterPrivilegeChangeRequestAuditEventBuilder)ClusterPrivilegeChangeRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withUsers(users).withGroups(groups).withRoles(roles).build();
            }
            case POST: {
                String role = users.isEmpty() ? (String)Iterables.getFirst(groups.keySet(), null) : (String)Iterables.getFirst(users.keySet(), null);
                return ((PrivilegeChangeRequestAuditEvent.PrivilegeChangeRequestAuditEventBuilder)((PrivilegeChangeRequestAuditEvent.PrivilegeChangeRequestAuditEventBuilder)((PrivilegeChangeRequestAuditEvent.PrivilegeChangeRequestAuditEventBuilder)((PrivilegeChangeRequestAuditEvent.PrivilegeChangeRequestAuditEventBuilder)((PrivilegeChangeRequestAuditEvent.PrivilegeChangeRequestAuditEventBuilder)((PrivilegeChangeRequestAuditEvent.PrivilegeChangeRequestAuditEventBuilder)PrivilegeChangeRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withRole(role).withGroup(groups.get(role) == null ? null : groups.get(role).get(0)).withUser(users.get(role) == null ? null : users.get(role).get(0)).withOperation((users.isEmpty() ? (groups.isEmpty() ? "" : "Group ") : "User ") + "role change")).build();
            }
        }
        return null;
    }

    private Map<String, List<String>> getEntities(Request request, String type) {
        HashMap<String, List<String>> entities = new HashMap<String, List<String>>();
        for (Map<String, Object> propertyMap : request.getBody().getPropertySets()) {
            String ptype = String.valueOf(propertyMap.get("PrivilegeInfo/principal_type"));
            if (!type.equals(ptype)) continue;
            String role = String.valueOf(propertyMap.get("PrivilegeInfo/permission_name"));
            String name = String.valueOf(propertyMap.get("PrivilegeInfo/principal_name"));
            if (!entities.containsKey(role)) {
                entities.put(role, new LinkedList());
            }
            ((List)entities.get(role)).add(name);
        }
        return entities;
    }
}

