/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.AddUserToGroupRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.MembershipChangeRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.RemoveUserFromGroupRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.internal.MemberResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Set;

public class MemberEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.Member).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        switch (request.getRequestType()) {
            case POST: {
                return ((AddUserToGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((AddUserToGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((AddUserToGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((AddUserToGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((AddUserToGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)AddUserToGroupRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withAffectedUserName(this.getUserName(request)).withGroupName(this.getGroupName(request)).build();
            }
            case DELETE: {
                return ((RemoveUserFromGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((RemoveUserFromGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((RemoveUserFromGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((RemoveUserFromGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((RemoveUserFromGroupRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)RemoveUserFromGroupRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withAffectedUserName(this.getUserName(request)).withGroupName(this.getGroupName(request)).build();
            }
            case PUT: {
                return ((MembershipChangeRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((MembershipChangeRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((MembershipChangeRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((MembershipChangeRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)((MembershipChangeRequestAuditEvent.AddUserToGroupRequestAuditEventBuilder)MembershipChangeRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withGroupName(RequestAuditEventCreatorHelper.getProperty(request, MemberResourceProvider.MEMBER_GROUP_NAME_PROPERTY_ID)).withUserNameList(RequestAuditEventCreatorHelper.getPropertyList(request, MemberResourceProvider.MEMBER_USER_NAME_PROPERTY_ID)).build();
            }
        }
        return null;
    }

    private String getUserName(Request request) {
        return request.getResource().getKeyValueMap().get(Resource.Type.Member);
    }

    private String getGroupName(Request request) {
        return request.getResource().getKeyValueMap().get(Resource.Type.Group);
    }
}

