/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import id.onyx.obdp.server.api.services.NamedPropertySet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.AddComponentToHostRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.AddHostRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.DeleteHostRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.QUERY_POST, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.Host).build();
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile(".*Hosts/host_name\\s*=\\s*([^&\\s]+).*");

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        switch (request.getRequestType()) {
            case DELETE: {
                return ((DeleteHostRequestAuditEvent.DeleteHostRequestAuditEventBuilder)((DeleteHostRequestAuditEvent.DeleteHostRequestAuditEventBuilder)((DeleteHostRequestAuditEvent.DeleteHostRequestAuditEventBuilder)((DeleteHostRequestAuditEvent.DeleteHostRequestAuditEventBuilder)((DeleteHostRequestAuditEvent.DeleteHostRequestAuditEventBuilder)DeleteHostRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withHostName(request.getResource().getKeyValueMap().get(Resource.Type.Host)).build();
            }
            case POST: {
                return ((AddHostRequestAuditEvent.AddHostRequestAuditEventBuilder)((AddHostRequestAuditEvent.AddHostRequestAuditEventBuilder)((AddHostRequestAuditEvent.AddHostRequestAuditEventBuilder)((AddHostRequestAuditEvent.AddHostRequestAuditEventBuilder)((AddHostRequestAuditEvent.AddHostRequestAuditEventBuilder)AddHostRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withHostName(RequestAuditEventCreatorHelper.getNamedProperty(request, "Hosts/host_name")).build();
            }
            case QUERY_POST: {
                return ((AddComponentToHostRequestAuditEvent.AddComponentToHostRequestAuditEventBuilder)((AddComponentToHostRequestAuditEvent.AddComponentToHostRequestAuditEventBuilder)((AddComponentToHostRequestAuditEvent.AddComponentToHostRequestAuditEventBuilder)((AddComponentToHostRequestAuditEvent.AddComponentToHostRequestAuditEventBuilder)((AddComponentToHostRequestAuditEvent.AddComponentToHostRequestAuditEventBuilder)AddComponentToHostRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withHostName(this.getHostNameFromQuery(request)).withComponents(this.getHostComponents(request)).build();
            }
        }
        return null;
    }

    private Set<String> getHostComponents(Request request) {
        Set set;
        HashSet<String> components = new HashSet<String>();
        NamedPropertySet propertySet = (NamedPropertySet)Iterables.getFirst(request.getBody().getNamedPropertySets(), null);
        if (propertySet != null && propertySet.getProperties().get("host_components") instanceof Set && (set = (Set)propertySet.getProperties().get("host_components")) != null && !set.isEmpty()) {
            for (Map element : set) {
                components.add((String)element.get(HostComponentResourceProvider.COMPONENT_NAME));
            }
        }
        return components;
    }

    private String getHostNameFromQuery(Request request) {
        Matcher matcher = HOSTNAME_PATTERN.matcher(request.getURI());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

