/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.CreateGroupRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.DeleteGroupRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.internal.GroupResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Set;

public class GroupEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.Group).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        switch (request.getRequestType()) {
            case POST: {
                return ((CreateGroupRequestAuditEvent.CreateGroupRequestAuditEventBuilder)((CreateGroupRequestAuditEvent.CreateGroupRequestAuditEventBuilder)((CreateGroupRequestAuditEvent.CreateGroupRequestAuditEventBuilder)((CreateGroupRequestAuditEvent.CreateGroupRequestAuditEventBuilder)((CreateGroupRequestAuditEvent.CreateGroupRequestAuditEventBuilder)CreateGroupRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withGroupName(RequestAuditEventCreatorHelper.getProperty(request, GroupResourceProvider.GROUP_GROUPNAME_PROPERTY_ID)).build();
            }
            case DELETE: {
                return ((DeleteGroupRequestAuditEvent.DeleteGroupRequestAuditEventBuilder)((DeleteGroupRequestAuditEvent.DeleteGroupRequestAuditEventBuilder)((DeleteGroupRequestAuditEvent.DeleteGroupRequestAuditEventBuilder)((DeleteGroupRequestAuditEvent.DeleteGroupRequestAuditEventBuilder)((DeleteGroupRequestAuditEvent.DeleteGroupRequestAuditEventBuilder)DeleteGroupRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withGroupName(request.getResource().getKeyValueMap().get(Resource.Type.Group)).build();
            }
        }
        return null;
    }
}

