/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.ClusterNameChangeRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.ConfigurationChangeRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Map;
import java.util.Set;

public class ConfigurationChangeEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.Cluster).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        Map map;
        if (!request.getBody().getPropertySets().isEmpty() && (map = (Map)Iterables.getFirst(request.getBody().getPropertySets(), null)) != null && map.size() == 1 && map.containsKey("Clusters/cluster_name")) {
            String newName = String.valueOf(map.get("Clusters/cluster_name"));
            String oldName = request.getResource().getKeyValueMap().get(Resource.Type.Cluster);
            return ((ClusterNameChangeRequestAuditEvent.ClusterNameChangeRequestAuditEventBuilder)((ClusterNameChangeRequestAuditEvent.ClusterNameChangeRequestAuditEventBuilder)((ClusterNameChangeRequestAuditEvent.ClusterNameChangeRequestAuditEventBuilder)((ClusterNameChangeRequestAuditEvent.ClusterNameChangeRequestAuditEventBuilder)((ClusterNameChangeRequestAuditEvent.ClusterNameChangeRequestAuditEventBuilder)ClusterNameChangeRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withOldName(oldName).withNewName(newName).build();
        }
        return ((ConfigurationChangeRequestAuditEvent.ConfigurationChangeRequestAuditEventBuilder)((ConfigurationChangeRequestAuditEvent.ConfigurationChangeRequestAuditEventBuilder)((ConfigurationChangeRequestAuditEvent.ConfigurationChangeRequestAuditEventBuilder)((ConfigurationChangeRequestAuditEvent.ConfigurationChangeRequestAuditEventBuilder)((ConfigurationChangeRequestAuditEvent.ConfigurationChangeRequestAuditEventBuilder)ConfigurationChangeRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withVersionNote(this.getServiceConfigVersionNote(result)).withVersionNumber(this.getServiceConfigVersion(result)).build();
    }

    private String getServiceConfigVersion(Result result) {
        Map<String, Object> map = this.getServiceConfigMap(result);
        return map == null ? null : String.valueOf(map.get("service_config_version"));
    }

    private String getServiceConfigVersionNote(Result result) {
        Map<String, Object> map = this.getServiceConfigMap(result);
        return map == null ? null : String.valueOf(map.get("service_config_version_note"));
    }

    private Map<String, Object> getServiceConfigMap(Result result) {
        TreeNode first;
        if (result.getResultTree().getChild("resources") != null && (first = (TreeNode)Iterables.getFirst(result.getResultTree().getChild("resources").getChildren(), null)) != null && first.getObject() != null) {
            return ((Resource)first.getObject()).getPropertiesMap().get("");
        }
        return null;
    }
}

