/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.StartOperationRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Map;
import java.util.Set;

public class ComponentEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.HostComponent).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        String operation = this.getOperation(request);
        Long requestId = null;
        if (this.containsRequestId(result)) {
            requestId = this.getRequestId(result);
        }
        StartOperationRequestAuditEvent.StartOperationAuditEventBuilder auditEventBuilder = ((StartOperationRequestAuditEvent.StartOperationAuditEventBuilder)((StartOperationRequestAuditEvent.StartOperationAuditEventBuilder)StartOperationRequestAuditEvent.builder().withOperation(operation).withRemoteIp(request.getRemoteAddress())).withTimestamp(System.currentTimeMillis())).withHostname(RequestAuditEventCreatorHelper.getProperty(request, HostComponentResourceProvider.HOST_NAME)).withRequestId(String.valueOf(requestId));
        if (result.getStatus().isErrorState()) {
            auditEventBuilder.withReasonOfFailure(result.getStatus().getMessage());
        }
        return auditEventBuilder.build();
    }

    private String getOperation(Request request) {
        if (request.getRequestType() == Request.Type.DELETE) {
            return "Delete component " + request.getResource().getKeyValueMap().get(Resource.Type.HostComponent);
        }
        if (request.getBody().getRequestInfoProperties() != null && request.getBody().getRequestInfoProperties().containsKey("operation_level/level")) {
            Object operation = "";
            block5 : switch (request.getBody().getRequestInfoProperties().get("operation_level/level")) {
                case "CLUSTER": {
                    for (Map<String, Object> map : request.getBody().getPropertySets()) {
                        if (!map.containsKey(HostComponentResourceProvider.CLUSTER_NAME)) continue;
                        operation = String.valueOf(map.get(HostComponentResourceProvider.STATE)) + ": all services on all hosts" + (String)(request.getBody().getQueryString() != null && request.getBody().getQueryString().length() > 0 ? " that matches " + request.getBody().getQueryString() : "") + " (" + request.getBody().getRequestInfoProperties().get("operation_level/cluster_name") + ")";
                        break block5;
                    }
                    break;
                }
                case "HOST": {
                    for (Map<String, Object> map : request.getBody().getPropertySets()) {
                        if (!map.containsKey(HostComponentResourceProvider.CLUSTER_NAME)) continue;
                        String query = request.getBody().getRequestInfoProperties().get("query");
                        operation = String.valueOf(map.get(HostComponentResourceProvider.STATE)) + ": " + query.substring(query.indexOf("(") + 1, query.length() - 1) + " on " + request.getBody().getRequestInfoProperties().get("operation_level/host_name") + " (" + request.getBody().getRequestInfoProperties().get("operation_level/cluster_name") + ")";
                        break block5;
                    }
                    break;
                }
                case "HOST_COMPONENT": {
                    for (Map<String, Object> map : request.getBody().getPropertySets()) {
                        if (!map.containsKey(HostComponentResourceProvider.COMPONENT_NAME)) continue;
                        operation = String.valueOf(map.get(HostComponentResourceProvider.STATE)) + ": " + String.valueOf(map.get(HostComponentResourceProvider.COMPONENT_NAME)) + "/" + request.getBody().getRequestInfoProperties().get("operation_level/service_name") + " on " + request.getBody().getRequestInfoProperties().get("operation_level/host_name") + " (" + request.getBody().getRequestInfoProperties().get("operation_level/cluster_name") + ")";
                        break block5;
                    }
                    break;
                }
            }
            return operation;
        }
        for (Map<String, Object> map : request.getBody().getPropertySets()) {
            if (!map.containsKey(HostComponentResourceProvider.MAINTENANCE_STATE)) continue;
            return "Turn " + map.get(HostComponentResourceProvider.MAINTENANCE_STATE) + " Maintenance Mode for " + map.get(HostComponentResourceProvider.COMPONENT_NAME);
        }
        return null;
    }

    private Long getRequestId(Result result) {
        return (Long)result.getResultTree().getChild("request").getObject().getPropertiesMap().get("Requests").get("id");
    }

    private boolean containsRequestId(Result result) {
        return result.getResultTree().getChild("request") != null && result.getResultTree().getChild("request").getObject() != null && result.getResultTree().getChild("request").getObject().getPropertiesMap().get("Requests") != null && result.getResultTree().getChild("request").getObject().getPropertiesMap().get("Requests").get("id") != null;
    }
}

