/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request.eventcreator;

import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.request.AddAlertTargetRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.ChangeAlertTargetRequestAuditEvent;
import id.onyx.obdp.server.audit.event.request.DeleteAlertTargetRequestAuditEvent;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreatorHelper;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Set;

public class AlertTargetEventCreator
implements RequestAuditEventCreator {
    private Set<Request.Type> requestTypes = ImmutableSet.builder().add((Object[])new Request.Type[]{Request.Type.PUT, Request.Type.POST, Request.Type.DELETE}).build();
    private Set<Resource.Type> resourceTypes = ImmutableSet.builder().add((Object)Resource.Type.AlertTarget).build();

    @Override
    public Set<Request.Type> getRequestTypes() {
        return this.requestTypes;
    }

    @Override
    public Set<Resource.Type> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public Set<ResultStatus.STATUS> getResultStatuses() {
        return null;
    }

    @Override
    public AuditEvent createAuditEvent(Request request, Result result) {
        switch (request.getRequestType()) {
            case POST: {
                return ((AddAlertTargetRequestAuditEvent.AddAlertTargetRequestAuditEventBuilder)((AddAlertTargetRequestAuditEvent.AddAlertTargetRequestAuditEventBuilder)((AddAlertTargetRequestAuditEvent.AddAlertTargetRequestAuditEventBuilder)((AddAlertTargetRequestAuditEvent.AddAlertTargetRequestAuditEventBuilder)((AddAlertTargetRequestAuditEvent.AddAlertTargetRequestAuditEventBuilder)AddAlertTargetRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withName(RequestAuditEventCreatorHelper.getProperty(request, "AlertTarget/name")).withDescription(RequestAuditEventCreatorHelper.getProperty(request, "AlertTarget/description")).withAlertStates(RequestAuditEventCreatorHelper.getNamedPropertyList(request, "AlertTarget/alert_states")).withGroupIds(RequestAuditEventCreatorHelper.getNamedPropertyList(request, "AlertTarget/groups")).withNotificationType(RequestAuditEventCreatorHelper.getProperty(request, "AlertTarget/notification_type")).withEmailFrom(RequestAuditEventCreatorHelper.getProperty(request, "AlertTarget/properties/mail.smtp.from")).withEmailRecipients(RequestAuditEventCreatorHelper.getNamedPropertyList(request, "AlertTarget/properties/ambari.dispatch.recipients")).build();
            }
            case PUT: {
                return ((ChangeAlertTargetRequestAuditEvent.ChangeAlertTargetRequestAuditEventBuilder)((ChangeAlertTargetRequestAuditEvent.ChangeAlertTargetRequestAuditEventBuilder)((ChangeAlertTargetRequestAuditEvent.ChangeAlertTargetRequestAuditEventBuilder)((ChangeAlertTargetRequestAuditEvent.ChangeAlertTargetRequestAuditEventBuilder)((ChangeAlertTargetRequestAuditEvent.ChangeAlertTargetRequestAuditEventBuilder)ChangeAlertTargetRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withName(RequestAuditEventCreatorHelper.getProperty(request, "AlertTarget/name")).withDescription(RequestAuditEventCreatorHelper.getProperty(request, "AlertTarget/description")).withAlertStates(RequestAuditEventCreatorHelper.getNamedPropertyList(request, "AlertTarget/alert_states")).withGroupIds(RequestAuditEventCreatorHelper.getNamedPropertyList(request, "AlertTarget/groups")).withNotificationType(RequestAuditEventCreatorHelper.getProperty(request, "AlertTarget/notification_type")).withEmailFrom(RequestAuditEventCreatorHelper.getProperty(request, "AlertTarget/properties/mail.smtp.from")).withEmailRecipients(RequestAuditEventCreatorHelper.getNamedPropertyList(request, "AlertTarget/properties/ambari.dispatch.recipients")).build();
            }
            case DELETE: {
                return ((DeleteAlertTargetRequestAuditEvent.DeleteAlertTargetRequestAuditEventBuilder)((DeleteAlertTargetRequestAuditEvent.DeleteAlertTargetRequestAuditEventBuilder)((DeleteAlertTargetRequestAuditEvent.DeleteAlertTargetRequestAuditEventBuilder)((DeleteAlertTargetRequestAuditEvent.DeleteAlertTargetRequestAuditEventBuilder)((DeleteAlertTargetRequestAuditEvent.DeleteAlertTargetRequestAuditEventBuilder)DeleteAlertTargetRequestAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestType(request.getRequestType())).withResultStatus(result.getStatus())).withUrl(request.getURI())).withRemoteIp(request.getRemoteAddress())).withId(request.getResource().getKeyValueMap().get(Resource.Type.AlertTarget)).build();
            }
        }
        return null;
    }
}

