/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.request.RequestAuditLogger;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Set;

@Singleton
public class RequestAuditLoggerImpl
implements RequestAuditLogger {
    private static final int REQUEST_TYPE_PRIORITY = 1;
    private static final int RESULT_STATUS_PRIORITY = 2;
    private static final int RESOURCE_TYPE_PRIORITY = 4;
    private Set<RequestAuditEventCreator> creators;
    private AuditLogger auditLogger;

    @Inject
    public RequestAuditLoggerImpl(AuditLogger auditLogger, Set<RequestAuditEventCreator> creatorSet) {
        this.auditLogger = auditLogger;
        this.creators = creatorSet;
    }

    @Override
    public void log(Request request, Result result) {
        AuditEvent ae;
        if (!this.auditLogger.isEnabled()) {
            return;
        }
        Resource.Type resourceType = request.getResource().getResourceDefinition().getType();
        Request.Type requestType = request.getRequestType();
        ResultStatus resultStatus = result.getStatus();
        RequestAuditEventCreator creator = this.selectCreator(resourceType, resultStatus, requestType);
        if (creator != null && (ae = creator.createAuditEvent(request, result)) != null) {
            this.auditLogger.log(ae);
        }
    }

    private RequestAuditEventCreator selectCreator(Resource.Type resourceType, ResultStatus resultStatus, Request.Type requestType) {
        RequestAuditEventCreator selected = null;
        Integer priority = -1;
        for (RequestAuditEventCreator creator : this.creators) {
            Integer creatorPriority = this.getPriority(creator, resourceType, resultStatus, requestType);
            if (creatorPriority == null || priority >= creatorPriority) continue;
            priority = creatorPriority;
            selected = creator;
        }
        return selected;
    }

    private Integer getPriority(RequestAuditEventCreator creator, Resource.Type resourceType, ResultStatus resultStatus, Request.Type requestType) {
        Integer priority = 0;
        if (this.isIncompatible(creator, resourceType, resultStatus, requestType)) {
            return null;
        }
        priority = priority + (creator.getRequestTypes() != null && creator.getRequestTypes().contains((Object)requestType) ? 1 : 0);
        priority = priority + (creator.getResultStatuses() != null && creator.getResultStatuses().contains((Object)resultStatus.getStatus()) ? 2 : 0);
        priority = priority + (creator.getResourceTypes() != null && creator.getResourceTypes().contains(resourceType) ? 4 : 0);
        return priority;
    }

    private boolean isIncompatible(RequestAuditEventCreator creator, Resource.Type resourceType, ResultStatus resultStatus, Request.Type requestType) {
        return creator.getRequestTypes() != null && !creator.getRequestTypes().contains((Object)requestType) || creator.getResultStatuses() != null && !creator.getResultStatuses().contains((Object)resultStatus.getStatus()) || creator.getResourceTypes() != null && !creator.getResourceTypes().contains(resourceType);
    }
}

