/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.request;

import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.audit.event.AbstractUserAuditEvent;

public abstract class RequestAuditEvent
extends AbstractUserAuditEvent {
    protected RequestAuditEvent() {
    }

    protected RequestAuditEvent(RequestAuditEventBuilder<?, ?> builder) {
        super((AbstractUserAuditEvent.AbstractUserAuditEventBuilder<?, ?>)builder);
    }

    public static abstract class RequestAuditEventBuilder<T extends RequestAuditEvent, TBuilder extends RequestAuditEventBuilder<T, TBuilder>>
    extends AbstractUserAuditEvent.AbstractUserAuditEventBuilder<T, TBuilder> {
        private Request.Type requestType;
        private ResultStatus resultStatus;
        private String url;
        private String operation;

        protected RequestAuditEventBuilder(Class<? extends TBuilder> builderClass) {
            super(builderClass);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            if (this.operation != null) {
                builder.append(", Operation(").append(this.operation).append(")");
            }
            builder.append(", RequestType(").append((Object)this.requestType).append("), ").append("url(").append(this.url).append("), ResultStatus(").append(this.resultStatus.getStatusCode()).append(" ").append((Object)this.resultStatus.getStatus()).append(")");
            if (this.resultStatus.isErrorState()) {
                builder.append(", Reason(").append(this.resultStatus.getMessage()).append(")");
            }
        }

        public TBuilder withRequestType(Request.Type requestType) {
            this.requestType = requestType;
            return (TBuilder)((RequestAuditEventBuilder)this.self());
        }

        public TBuilder withUrl(String url) {
            this.url = url;
            return (TBuilder)((RequestAuditEventBuilder)this.self());
        }

        public TBuilder withResultStatus(ResultStatus resultStatus) {
            this.resultStatus = resultStatus;
            return (TBuilder)((RequestAuditEventBuilder)this.self());
        }

        public TBuilder withOperation(String operation) {
            this.operation = operation;
            return (TBuilder)((RequestAuditEventBuilder)this.self());
        }
    }
}

