/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class ViewPrivilegeChangeRequestAuditEvent
extends RequestAuditEvent {
    protected ViewPrivilegeChangeRequestAuditEvent() {
    }

    protected ViewPrivilegeChangeRequestAuditEvent(ViewPrivilegeChangeRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static ViewPrivilegeChangeRequestAuditEventBuilder builder() {
        return new ViewPrivilegeChangeRequestAuditEventBuilder();
    }

    public static class ViewPrivilegeChangeRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<ViewPrivilegeChangeRequestAuditEvent, ViewPrivilegeChangeRequestAuditEventBuilder> {
        private Map<String, List<String>> users;
        private Map<String, List<String>> groups;
        private Map<String, List<String>> roles;
        private String name;
        private String type;
        private String version;

        public ViewPrivilegeChangeRequestAuditEventBuilder() {
            super(ViewPrivilegeChangeRequestAuditEventBuilder.class);
            super.withOperation("View permission change");
        }

        @Override
        protected ViewPrivilegeChangeRequestAuditEvent newAuditEvent() {
            return new ViewPrivilegeChangeRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Type(").append(this.type).append("), Version(").append(this.version).append("), Name(").append(this.name).append(")");
            TreeSet<String> roleSet = new TreeSet<String>();
            roleSet.addAll(this.users.keySet());
            roleSet.addAll(this.groups.keySet());
            roleSet.addAll(this.roles.keySet());
            builder.append(", Permissions(");
            LinkedList<Object> lines = new LinkedList<Object>();
            for (String role : roleSet) {
                LinkedList<CallSite> tmpLines = new LinkedList<CallSite>();
                lines.add(role + ": [");
                if (this.users.get(role) != null && !this.users.get(role).isEmpty()) {
                    tmpLines.add((CallSite)((Object)("Users: " + StringUtils.join((Collection)this.users.get(role), (String)", "))));
                }
                if (this.groups.get(role) != null && !this.groups.get(role).isEmpty()) {
                    tmpLines.add((CallSite)((Object)("Groups: " + StringUtils.join((Collection)this.groups.get(role), (String)", "))));
                }
                if (this.roles.get(role) != null && !this.roles.get(role).isEmpty()) {
                    tmpLines.add((CallSite)((Object)("Roles: " + StringUtils.join((Collection)this.roles.get(role), (String)", "))));
                }
                lines.add(StringUtils.join(tmpLines, (String)";"));
                lines.add("] ");
            }
            builder.append(StringUtils.join(lines, (String)""));
            builder.append(")");
        }

        public ViewPrivilegeChangeRequestAuditEventBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ViewPrivilegeChangeRequestAuditEventBuilder withType(String type) {
            this.type = type;
            return this;
        }

        public ViewPrivilegeChangeRequestAuditEventBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public ViewPrivilegeChangeRequestAuditEventBuilder withUsers(Map<String, List<String>> users) {
            this.users = users;
            return this;
        }

        public ViewPrivilegeChangeRequestAuditEventBuilder withGroups(Map<String, List<String>> groups) {
            this.groups = groups;
            return this;
        }

        public ViewPrivilegeChangeRequestAuditEventBuilder withRoles(Map<String, List<String>> roles) {
            this.roles = roles;
            return this;
        }
    }
}

