/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.event.AbstractUserAuditEvent;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StartOperationRequestAuditEvent
extends AbstractUserAuditEvent {
    private StartOperationRequestAuditEvent() {
    }

    private StartOperationRequestAuditEvent(StartOperationAuditEventBuilder builder) {
        super(builder);
    }

    public static StartOperationAuditEventBuilder builder() {
        return new StartOperationAuditEventBuilder();
    }

    public static class StartOperationAuditEventBuilder
    extends AbstractUserAuditEvent.AbstractUserAuditEventBuilder<StartOperationRequestAuditEvent, StartOperationAuditEventBuilder> {
        private String requestId;
        private String reasonOfFailure;
        private String operation;
        private String hostname;

        private StartOperationAuditEventBuilder() {
            super(StartOperationAuditEventBuilder.class);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Operation(").append(this.operation);
            if (this.hostname != null) {
                builder.append("), Host name(").append(this.hostname);
            }
            builder.append("), RequestId(").append(this.requestId).append("), Status(").append(this.reasonOfFailure == null ? "Successfully queued" : "Failed to queue");
            if (this.reasonOfFailure != null) {
                builder.append("), Reason(").append(this.reasonOfFailure);
            }
            builder.append(")");
        }

        @Override
        protected StartOperationRequestAuditEvent newAuditEvent() {
            return new StartOperationRequestAuditEvent(this);
        }

        public StartOperationAuditEventBuilder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public StartOperationAuditEventBuilder withReasonOfFailure(String reasonOfFailure) {
            this.reasonOfFailure = reasonOfFailure;
            return this;
        }

        public StartOperationAuditEventBuilder withOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public StartOperationAuditEventBuilder withHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }
    }
}

