/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PrivilegeChangeRequestAuditEvent
extends RequestAuditEvent {
    protected PrivilegeChangeRequestAuditEvent() {
    }

    protected PrivilegeChangeRequestAuditEvent(PrivilegeChangeRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static PrivilegeChangeRequestAuditEventBuilder builder() {
        return new PrivilegeChangeRequestAuditEventBuilder();
    }

    public static class PrivilegeChangeRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<PrivilegeChangeRequestAuditEvent, PrivilegeChangeRequestAuditEventBuilder> {
        private String user;
        private String group;
        private String role;

        public PrivilegeChangeRequestAuditEventBuilder() {
            super(PrivilegeChangeRequestAuditEventBuilder.class);
            super.withOperation("Role change");
        }

        @Override
        protected PrivilegeChangeRequestAuditEvent newAuditEvent() {
            return new PrivilegeChangeRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Role(").append(this.role).append(")");
            if (this.user != null) {
                builder.append(", User(").append(this.user).append(")");
            }
            if (this.group != null) {
                builder.append(", Group(").append(this.group).append(")");
            }
        }

        public PrivilegeChangeRequestAuditEventBuilder withUser(String user) {
            this.user = user;
            return this;
        }

        public PrivilegeChangeRequestAuditEventBuilder withGroup(String group) {
            this.group = group;
            return this;
        }

        public PrivilegeChangeRequestAuditEventBuilder withRole(String role) {
            this.role = role;
            return this;
        }
    }
}

