/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class MembershipChangeRequestAuditEvent
extends RequestAuditEvent {
    protected MembershipChangeRequestAuditEvent() {
    }

    protected MembershipChangeRequestAuditEvent(AddUserToGroupRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static AddUserToGroupRequestAuditEventBuilder builder() {
        return new AddUserToGroupRequestAuditEventBuilder();
    }

    public static class AddUserToGroupRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<MembershipChangeRequestAuditEvent, AddUserToGroupRequestAuditEventBuilder> {
        private List<String> userNameList;
        private String groupName;

        public AddUserToGroupRequestAuditEventBuilder() {
            super(AddUserToGroupRequestAuditEventBuilder.class);
            super.withOperation("Membership change");
        }

        @Override
        protected MembershipChangeRequestAuditEvent newAuditEvent() {
            return new MembershipChangeRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Group(").append(this.groupName).append("), Members(");
            if (this.userNameList.isEmpty()) {
                builder.append("<empty>");
            } else {
                builder.append(StringUtils.join(this.userNameList, (String)", "));
            }
            builder.append(")");
        }

        public AddUserToGroupRequestAuditEventBuilder withUserNameList(List<String> users) {
            this.userNameList = users;
            return this;
        }

        public AddUserToGroupRequestAuditEventBuilder withGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }
    }
}

