/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CreateUserRequestAuditEvent
extends RequestAuditEvent {
    protected CreateUserRequestAuditEvent() {
    }

    protected CreateUserRequestAuditEvent(CreateUserRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static CreateUserRequestAuditEventBuilder builder() {
        return new CreateUserRequestAuditEventBuilder();
    }

    public static class CreateUserRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<CreateUserRequestAuditEvent, CreateUserRequestAuditEventBuilder> {
        private boolean admin;
        private boolean active;
        private String username;

        public CreateUserRequestAuditEventBuilder() {
            super(CreateUserRequestAuditEventBuilder.class);
            super.withOperation("User creation");
        }

        @Override
        protected CreateUserRequestAuditEvent newAuditEvent() {
            return new CreateUserRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Created Username(").append(this.username).append("), Active(").append(this.active ? "yes" : "no").append("), ").append("Administrator(").append(this.admin ? "yes" : "no").append(")");
        }

        public CreateUserRequestAuditEventBuilder withAdmin(boolean admin) {
            this.admin = admin;
            return this;
        }

        public CreateUserRequestAuditEventBuilder withActive(boolean active) {
            this.active = active;
            return this;
        }

        public CreateUserRequestAuditEventBuilder withCreatedUsername(String username) {
            this.username = username;
            return this;
        }
    }
}

