/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class ClusterPrivilegeChangeRequestAuditEvent
extends RequestAuditEvent {
    protected ClusterPrivilegeChangeRequestAuditEvent() {
    }

    protected ClusterPrivilegeChangeRequestAuditEvent(ClusterPrivilegeChangeRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static ClusterPrivilegeChangeRequestAuditEventBuilder builder() {
        return new ClusterPrivilegeChangeRequestAuditEventBuilder();
    }

    public static class ClusterPrivilegeChangeRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<ClusterPrivilegeChangeRequestAuditEvent, ClusterPrivilegeChangeRequestAuditEventBuilder> {
        private Map<String, List<String>> users;
        private Map<String, List<String>> groups;
        private Map<String, List<String>> roles;

        public ClusterPrivilegeChangeRequestAuditEventBuilder() {
            super(ClusterPrivilegeChangeRequestAuditEventBuilder.class);
            super.withOperation("Role change");
        }

        @Override
        protected ClusterPrivilegeChangeRequestAuditEvent newAuditEvent() {
            return new ClusterPrivilegeChangeRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            TreeSet<String> roleSet = new TreeSet<String>();
            roleSet.addAll(this.users.keySet());
            roleSet.addAll(this.groups.keySet());
            roleSet.addAll(this.roles.keySet());
            builder.append(", Roles(");
            LinkedList<Object> lines = new LinkedList<Object>();
            for (String role : roleSet) {
                LinkedList<CallSite> tmpLines = new LinkedList<CallSite>();
                lines.add(role + ": [");
                if (this.users.get(role) != null && !this.users.get(role).isEmpty()) {
                    tmpLines.add((CallSite)((Object)("Users: " + StringUtils.join((Collection)this.users.get(role), (String)", "))));
                }
                if (this.groups.get(role) != null && !this.groups.get(role).isEmpty()) {
                    tmpLines.add((CallSite)((Object)("Groups: " + StringUtils.join((Collection)this.groups.get(role), (String)", "))));
                }
                if (this.roles.get(role) != null && !this.roles.get(role).isEmpty()) {
                    tmpLines.add((CallSite)((Object)("Roles: " + StringUtils.join((Collection)this.roles.get(role), (String)", "))));
                }
                lines.add(StringUtils.join(tmpLines, (String)";"));
                lines.add("] ");
            }
            builder.append(StringUtils.join(lines, (String)""));
            builder.append(")");
        }

        public ClusterPrivilegeChangeRequestAuditEventBuilder withUsers(Map<String, List<String>> users) {
            this.users = users;
            return this;
        }

        public ClusterPrivilegeChangeRequestAuditEventBuilder withGroups(Map<String, List<String>> groups) {
            this.groups = groups;
            return this;
        }

        public ClusterPrivilegeChangeRequestAuditEventBuilder withRoles(Map<String, List<String>> roles) {
            this.roles = roles;
            return this;
        }
    }
}

