/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;

public class ClusterNameChangeRequestAuditEvent
extends RequestAuditEvent {
    protected ClusterNameChangeRequestAuditEvent() {
    }

    protected ClusterNameChangeRequestAuditEvent(ClusterNameChangeRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static ClusterNameChangeRequestAuditEventBuilder builder() {
        return new ClusterNameChangeRequestAuditEventBuilder();
    }

    public static class ClusterNameChangeRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<ClusterNameChangeRequestAuditEvent, ClusterNameChangeRequestAuditEventBuilder> {
        private String oldName;
        private String newName;

        public ClusterNameChangeRequestAuditEventBuilder() {
            super(ClusterNameChangeRequestAuditEventBuilder.class);
            super.withOperation("Cluster name change");
        }

        @Override
        protected ClusterNameChangeRequestAuditEvent newAuditEvent() {
            return new ClusterNameChangeRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Old name(").append(this.oldName).append("), New name(").append(this.newName).append(")");
        }

        public ClusterNameChangeRequestAuditEventBuilder withOldName(String oldName) {
            this.oldName = oldName;
            return this;
        }

        public ClusterNameChangeRequestAuditEventBuilder withNewName(String newName) {
            this.newName = newName;
            return this;
        }
    }
}

