/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChangeRepositoryVersionRequestAuditEvent
extends RequestAuditEvent {
    protected ChangeRepositoryVersionRequestAuditEvent() {
    }

    protected ChangeRepositoryVersionRequestAuditEvent(ChangeRepositoryVersionAuditEventBuilder builder) {
        super(builder);
    }

    public static ChangeRepositoryVersionAuditEventBuilder builder() {
        return new ChangeRepositoryVersionAuditEventBuilder();
    }

    public static class ChangeRepositoryVersionAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<ChangeRepositoryVersionRequestAuditEvent, ChangeRepositoryVersionAuditEventBuilder> {
        private String stackName;
        private String displayName;
        private String stackVersion;
        private String repoVersion;
        private SortedMap<String, List<Map<String, String>>> repos;

        public ChangeRepositoryVersionAuditEventBuilder() {
            super(ChangeRepositoryVersionAuditEventBuilder.class);
            super.withOperation("Repository version change");
        }

        @Override
        protected ChangeRepositoryVersionRequestAuditEvent newAuditEvent() {
            return new ChangeRepositoryVersionRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Stack(").append(this.stackName).append("), Stack version(").append(this.stackVersion).append("), Display name(").append(this.displayName).append("), Repo version(").append(this.repoVersion).append("), Repositories(");
            for (Map.Entry<String, List<Map<String, String>>> repo : this.repos.entrySet()) {
                builder.append("Operating system: ").append(repo.getKey());
                builder.append("(");
                for (Map<String, String> properties : repo.getValue()) {
                    builder.append("Repository ID(").append(properties.get("repo_id"));
                    builder.append("), Repository name(").append(properties.get("repo_name"));
                    builder.append("), Base url(").append(properties.get("base_url")).append(")");
                    builder.append(")");
                }
            }
            builder.append(")");
        }

        public ChangeRepositoryVersionAuditEventBuilder withStackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public ChangeRepositoryVersionAuditEventBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ChangeRepositoryVersionAuditEventBuilder withStackVersion(String stackVersion) {
            this.stackVersion = stackVersion;
            return this;
        }

        public ChangeRepositoryVersionAuditEventBuilder withRepoVersion(String repoVersion) {
            this.repoVersion = repoVersion;
            return this;
        }

        public ChangeRepositoryVersionAuditEventBuilder withRepos(SortedMap<String, List<Map<String, String>>> repos) {
            this.repos = repos;
            return this;
        }
    }
}

