/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ChangeAlertTargetRequestAuditEvent
extends RequestAuditEvent {
    protected ChangeAlertTargetRequestAuditEvent() {
    }

    protected ChangeAlertTargetRequestAuditEvent(ChangeAlertTargetRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static ChangeAlertTargetRequestAuditEventBuilder builder() {
        return new ChangeAlertTargetRequestAuditEventBuilder();
    }

    public static class ChangeAlertTargetRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<ChangeAlertTargetRequestAuditEvent, ChangeAlertTargetRequestAuditEventBuilder> {
        private String name;
        private String description;
        private String notificationType;
        private List<String> groupIds;
        private String emailFrom;
        private List<String> emailRecipients;
        private List<String> alertStates;

        public ChangeAlertTargetRequestAuditEventBuilder() {
            super(ChangeAlertTargetRequestAuditEventBuilder.class);
            super.withOperation("Notification change");
        }

        @Override
        protected ChangeAlertTargetRequestAuditEvent newAuditEvent() {
            return new ChangeAlertTargetRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Notification name(").append(this.name).append("), Description(").append(this.description).append("), Notification type(").append(this.notificationType).append("), Group IDs(").append(StringUtils.join(this.groupIds, (String)", "));
            if (this.emailFrom != null) {
                builder.append("), Email from(").append(this.emailFrom);
            }
            if (this.emailRecipients != null && !this.emailRecipients.isEmpty()) {
                builder.append("), Email to(").append(StringUtils.join(this.emailRecipients, (String)", "));
            }
            builder.append("), Alert states(").append(StringUtils.join(this.alertStates, (String)", ")).append(")");
        }

        public ChangeAlertTargetRequestAuditEventBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ChangeAlertTargetRequestAuditEventBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public ChangeAlertTargetRequestAuditEventBuilder withNotificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public ChangeAlertTargetRequestAuditEventBuilder withGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
            return this;
        }

        public ChangeAlertTargetRequestAuditEventBuilder withEmailFrom(String emailFrom) {
            this.emailFrom = emailFrom;
            return this;
        }

        public ChangeAlertTargetRequestAuditEventBuilder withEmailRecipients(List<String> emailRecipients) {
            this.emailRecipients = emailRecipients;
            return this;
        }

        public ChangeAlertTargetRequestAuditEventBuilder withAlertStates(List<String> alertStates) {
            this.alertStates = alertStates;
            return this;
        }
    }
}

