/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AddRepositoryVersionRequestAuditEvent
extends RequestAuditEvent {
    protected AddRepositoryVersionRequestAuditEvent() {
    }

    protected AddRepositoryVersionRequestAuditEvent(AddRepositoryVersionAuditEventBuilder builder) {
        super(builder);
    }

    public static AddRepositoryVersionAuditEventBuilder builder() {
        return new AddRepositoryVersionAuditEventBuilder();
    }

    public static class AddRepositoryVersionAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<AddRepositoryVersionRequestAuditEvent, AddRepositoryVersionAuditEventBuilder> {
        private String stackName;
        private String displayName;
        private String stackVersion;
        private String repoVersion;
        private Map<String, List<Map<String, String>>> repos;

        public AddRepositoryVersionAuditEventBuilder() {
            super(AddRepositoryVersionAuditEventBuilder.class);
            super.withOperation("Repository version addition");
        }

        @Override
        protected AddRepositoryVersionRequestAuditEvent newAuditEvent() {
            return new AddRepositoryVersionRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Stack(").append(this.stackName).append("), Stack version(").append(this.stackVersion).append("), Display name(").append(this.displayName).append("), Repo version(").append(this.repoVersion).append("), Repositories(");
            for (Map.Entry<String, List<Map<String, String>>> repo : this.repos.entrySet()) {
                builder.append("Operating system: ").append(repo.getKey());
                builder.append("(");
                for (Map<String, String> properties : repo.getValue()) {
                    builder.append("Repository ID(").append(properties.get("repo_id"));
                    builder.append("), Repository name(").append(properties.get("repo_name"));
                    builder.append("), Base url(").append(properties.get("base_url")).append(")");
                    builder.append(")");
                }
            }
            builder.append(")");
        }

        public AddRepositoryVersionAuditEventBuilder withStackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public AddRepositoryVersionAuditEventBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public AddRepositoryVersionAuditEventBuilder withStackVersion(String stackVersion) {
            this.stackVersion = stackVersion;
            return this;
        }

        public AddRepositoryVersionAuditEventBuilder withRepoVersion(String repoVersion) {
            this.repoVersion = repoVersion;
            return this;
        }

        public AddRepositoryVersionAuditEventBuilder withRepos(Map<String, List<Map<String, String>>> repos) {
            this.repos = repos;
            return this;
        }
    }
}

