/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class AddComponentToHostRequestAuditEvent
extends RequestAuditEvent {
    protected AddComponentToHostRequestAuditEvent() {
    }

    protected AddComponentToHostRequestAuditEvent(AddComponentToHostRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static AddComponentToHostRequestAuditEventBuilder builder() {
        return new AddComponentToHostRequestAuditEventBuilder();
    }

    public static class AddComponentToHostRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<AddComponentToHostRequestAuditEvent, AddComponentToHostRequestAuditEventBuilder> {
        private String hostName;
        private Set<String> components;

        public AddComponentToHostRequestAuditEventBuilder() {
            super(AddComponentToHostRequestAuditEventBuilder.class);
            super.withOperation("Component addition to host");
        }

        @Override
        protected AddComponentToHostRequestAuditEvent newAuditEvent() {
            return new AddComponentToHostRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Hostname(").append(this.hostName).append("), Component(").append(this.components == null ? "" : StringUtils.join(this.components, (String)", ")).append(")");
        }

        public AddComponentToHostRequestAuditEventBuilder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public AddComponentToHostRequestAuditEventBuilder withComponents(Set<String> component) {
            this.components = component;
            return this;
        }
    }
}

