/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event.request;

import id.onyx.obdp.server.audit.request.RequestAuditEvent;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class AddAlertTargetRequestAuditEvent
extends RequestAuditEvent {
    protected AddAlertTargetRequestAuditEvent() {
    }

    protected AddAlertTargetRequestAuditEvent(AddAlertTargetRequestAuditEventBuilder builder) {
        super(builder);
    }

    public static AddAlertTargetRequestAuditEventBuilder builder() {
        return new AddAlertTargetRequestAuditEventBuilder();
    }

    public static class AddAlertTargetRequestAuditEventBuilder
    extends RequestAuditEvent.RequestAuditEventBuilder<AddAlertTargetRequestAuditEvent, AddAlertTargetRequestAuditEventBuilder> {
        private String name;
        private String description;
        private String notificationType;
        private List<String> groupIds;
        private String emailFrom;
        private List<String> emailRecipients;
        private List<String> alertStates;

        public AddAlertTargetRequestAuditEventBuilder() {
            super(AddAlertTargetRequestAuditEventBuilder.class);
            super.withOperation("Notification addition");
        }

        @Override
        protected AddAlertTargetRequestAuditEvent newAuditEvent() {
            return new AddAlertTargetRequestAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Notification name(").append(this.name).append("), Description(").append(this.description).append("), Notification type(").append(this.notificationType).append("), Group IDs(").append(StringUtils.join(this.groupIds, (String)", "));
            if (this.emailFrom != null) {
                builder.append("), Email from(").append(this.emailFrom);
            }
            if (this.emailRecipients != null && !this.emailRecipients.isEmpty()) {
                builder.append("), Email to(").append(StringUtils.join(this.emailRecipients, (String)", "));
            }
            builder.append("), Alert states(").append(StringUtils.join(this.alertStates, (String)", ")).append(")");
        }

        public AddAlertTargetRequestAuditEventBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public AddAlertTargetRequestAuditEventBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public AddAlertTargetRequestAuditEventBuilder withNotificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public AddAlertTargetRequestAuditEventBuilder withGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
            return this;
        }

        public AddAlertTargetRequestAuditEventBuilder withEmailFrom(String emailFrom) {
            this.emailFrom = emailFrom;
            return this;
        }

        public AddAlertTargetRequestAuditEventBuilder withEmailRecipients(List<String> emailRecipients) {
            this.emailRecipients = emailRecipients;
            return this;
        }

        public AddAlertTargetRequestAuditEventBuilder withAlertStates(List<String> alertStates) {
            this.alertStates = alertStates;
            return this;
        }
    }
}

