/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event;

import id.onyx.obdp.server.audit.event.AbstractUserAuditEvent;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TaskStatusAuditEvent
extends AbstractUserAuditEvent {
    private TaskStatusAuditEvent() {
    }

    private TaskStatusAuditEvent(TaskStatusAuditEventBuilder builder) {
        super(builder);
    }

    public static TaskStatusAuditEventBuilder builder() {
        return new TaskStatusAuditEventBuilder();
    }

    public static class TaskStatusAuditEventBuilder
    extends AbstractUserAuditEvent.AbstractUserAuditEventBuilder<TaskStatusAuditEvent, TaskStatusAuditEventBuilder> {
        private String requestId;
        private String taskId;
        private String hostName;
        private String status;
        private String operation;
        private String details;

        private TaskStatusAuditEventBuilder() {
            super(TaskStatusAuditEventBuilder.class);
        }

        @Override
        protected TaskStatusAuditEvent newAuditEvent() {
            return new TaskStatusAuditEvent(this);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Operation(").append(this.operation);
            if (this.details != null) {
                builder.append("), Details(").append(this.details);
            }
            builder.append("), Status(").append(this.status).append("), RequestId(").append(this.requestId).append("), TaskId(").append(this.taskId).append("), Hostname(").append(this.hostName).append(")");
        }

        public TaskStatusAuditEventBuilder withStatus(String status) {
            this.status = status;
            return this;
        }

        public TaskStatusAuditEventBuilder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public TaskStatusAuditEventBuilder withTaskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public TaskStatusAuditEventBuilder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public TaskStatusAuditEventBuilder withOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public TaskStatusAuditEventBuilder withDetails(String details) {
            this.details = details;
            return this;
        }
    }
}

