/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event;

import id.onyx.obdp.server.audit.event.AbstractUserAuditEvent;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class LoginAuditEvent
extends AbstractUserAuditEvent {
    private LoginAuditEvent() {
    }

    private LoginAuditEvent(LoginAuditEventBuilder builder) {
        super(builder);
    }

    public static LoginAuditEventBuilder builder() {
        return new LoginAuditEventBuilder();
    }

    public static class LoginAuditEventBuilder
    extends AbstractUserAuditEvent.AbstractUserAuditEventBuilder<LoginAuditEvent, LoginAuditEventBuilder> {
        private Map<String, List<String>> roles;
        private String reasonOfFailure;
        private Integer consecutiveFailures;

        private LoginAuditEventBuilder() {
            super(LoginAuditEventBuilder.class);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            super.buildAuditMessage(builder);
            builder.append(", Operation(User login), Roles(");
            if (this.roles != null && !this.roles.isEmpty()) {
                LinkedList<CallSite> lines = new LinkedList<CallSite>();
                for (Map.Entry<String, List<String>> entry : this.roles.entrySet()) {
                    lines.add((CallSite)((Object)(entry.getKey() + ": " + StringUtils.join((Collection)entry.getValue(), (String)", "))));
                }
                builder.append(StringUtils.join(lines, (String)","));
            }
            builder.append("), Status(").append(this.reasonOfFailure == null ? "Success" : "Failed");
            if (this.reasonOfFailure != null) {
                builder.append("), Reason(").append(this.reasonOfFailure);
                builder.append("), Consecutive failures(").append(this.consecutiveFailures == null ? "UNKNOWN USER" : String.valueOf(this.consecutiveFailures));
            }
            builder.append(")");
        }

        public LoginAuditEventBuilder withRoles(Map<String, List<String>> roles) {
            this.roles = roles;
            return this;
        }

        public LoginAuditEventBuilder withReasonOfFailure(String reasonOfFailure) {
            this.reasonOfFailure = reasonOfFailure;
            return this;
        }

        public LoginAuditEventBuilder withConsecutiveFailures(Integer consecutiveFailures) {
            this.consecutiveFailures = consecutiveFailures;
            return this;
        }

        @Override
        protected LoginAuditEvent newAuditEvent() {
            return new LoginAuditEvent(this);
        }
    }
}

