/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit.event;

import id.onyx.obdp.server.audit.event.AbstractAuditEvent;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractUserAuditEvent
extends AbstractAuditEvent {
    protected AbstractUserAuditEvent() {
    }

    protected AbstractUserAuditEvent(AbstractUserAuditEventBuilder<?, ?> builder) {
        super(builder);
    }

    public static abstract class AbstractUserAuditEventBuilder<T extends AbstractUserAuditEvent, TBuilder extends AbstractUserAuditEventBuilder<T, TBuilder>>
    extends AbstractAuditEvent.AbstractAuditEventBuilder<T, TBuilder> {
        private String userName = AuthorizationHelper.getAuthenticatedName();
        private String proxyUserName = AuthorizationHelper.getProxyUserName();
        private String remoteIp;

        protected AbstractUserAuditEventBuilder(Class<? extends TBuilder> builderClass) {
            super(builderClass);
        }

        @Override
        protected void buildAuditMessage(StringBuilder builder) {
            builder.append("User(").append(this.userName).append("), RemoteIp(").append(this.remoteIp).append(")");
            if (StringUtils.isNotEmpty((String)this.proxyUserName)) {
                builder.append(", ProxyUser(").append(this.proxyUserName).append(")");
            }
        }

        public TBuilder withUserName(String userName) {
            this.userName = userName;
            return (TBuilder)((AbstractUserAuditEventBuilder)this.self());
        }

        public TBuilder withProxyUserName(String proxyUserName) {
            this.proxyUserName = proxyUserName;
            return (TBuilder)((AbstractUserAuditEventBuilder)this.self());
        }

        public TBuilder withRemoteIp(String ip) {
            this.remoteIp = ip;
            return (TBuilder)((AbstractUserAuditEventBuilder)this.self());
        }
    }
}

