/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import id.onyx.obdp.server.audit.AsyncAuditLogger;
import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.AuditLoggerDefaultImpl;
import id.onyx.obdp.server.audit.request.RequestAuditLogger;
import id.onyx.obdp.server.audit.request.RequestAuditLoggerImpl;
import id.onyx.obdp.server.audit.request.eventcreator.RequestAuditEventCreator;
import id.onyx.obdp.server.cleanup.ClasspathScannerUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLoggerModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(AuditLoggerModule.class);

    protected List<Class<?>> getSelectors() {
        ArrayList selectorList = new ArrayList();
        selectorList.add(RequestAuditEventCreator.class);
        return selectorList;
    }

    protected List<Class<?>> getExclusions() {
        return Collections.emptyList();
    }

    protected String getPackageToScan() {
        return RequestAuditEventCreator.class.getPackage().getName();
    }

    protected void configure() {
        this.bind(AuditLogger.class).to(AsyncAuditLogger.class);
        this.bind(AuditLogger.class).annotatedWith((Annotation)Names.named((String)"AsyncAuditLogger")).to(AuditLoggerDefaultImpl.class);
        Multibinder multiBinder = Multibinder.newSetBinder((Binder)this.binder(), RequestAuditEventCreator.class);
        Set<Class<?>> bindingSet = ClasspathScannerUtils.findOnClassPath(this.getPackageToScan(), this.getExclusions(), this.getSelectors());
        for (Class<?> clazz : bindingSet) {
            LOG.info("Binding audit event creator {}", clazz);
            multiBinder.addBinding().to(clazz).in(Scopes.SINGLETON);
        }
        this.bind(RequestAuditLogger.class).to(RequestAuditLoggerImpl.class);
    }
}

