/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.configuration.Configuration;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuditLoggerDefaultImpl
implements AuditLogger {
    private static final Logger LOG = LoggerFactory.getLogger((String)"audit");
    private final boolean isEnabled;
    private ThreadLocal<DateFormat> dateFormatThreadLocal = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
        }
    };

    @Inject
    public AuditLoggerDefaultImpl(Configuration configuration) {
        this.isEnabled = configuration.isAuditLogEnabled();
    }

    @Override
    @Subscribe
    public void log(AuditEvent event) {
        if (!this.isEnabled) {
            return;
        }
        Date date = new Date(event.getTimestamp());
        LOG.info("{}, {}", (Object)this.dateFormatThreadLocal.get().format(date), (Object)event.getAuditMessage());
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }
}

