/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.audit;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.configuration.Configuration;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
class AsyncAuditLogger
implements AuditLogger {
    static final String InnerLogger = "AsyncAuditLogger";
    private EventBus eventBus;
    private final boolean isEnabled;

    @Inject
    public AsyncAuditLogger(@Named(value="AsyncAuditLogger") AuditLogger auditLogger, Configuration configuration) {
        this.isEnabled = configuration.isAuditLogEnabled();
        if (this.isEnabled) {
            this.eventBus = new AsyncEventBus("AuditLoggerEventBus", (Executor)new ThreadPoolExecutor(0, 1, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(configuration.getAuditLoggerCapacity()), new AuditLogThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            this.eventBus.register((Object)auditLogger);
        }
    }

    @Override
    public void log(AuditEvent event) {
        if (this.isEnabled) {
            this.eventBus.post((Object)event);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    private static final class AuditLogThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger nextId = new AtomicInteger(1);

        private AuditLogThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "auditlog-" + nextId.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }
}

