/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.util;

import id.onyx.obdp.server.api.util.TreeNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class TreeNodeImpl<T>
implements TreeNode<T> {
    private String m_name;
    private TreeNode<T> m_parent;
    private Map<String, TreeNode<T>> m_mapChildren = new LinkedHashMap<String, TreeNode<T>>();
    private T m_object;
    private Map<String, Object> m_mapNodeProps;

    public TreeNodeImpl(TreeNode<T> parent, T object, String name) {
        this.m_parent = parent;
        this.m_object = object;
        this.m_name = name;
    }

    @Override
    public TreeNode<T> getParent() {
        return this.m_parent;
    }

    @Override
    public Collection<TreeNode<T>> getChildren() {
        return this.m_mapChildren.values();
    }

    @Override
    public T getObject() {
        return this.m_object;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setParent(TreeNode<T> parent) {
        this.m_parent = parent;
    }

    @Override
    public TreeNode<T> addChild(T child, String name) {
        TreeNodeImpl<T> node = new TreeNodeImpl<T>(this, child, name);
        this.m_mapChildren.put(name, node);
        return node;
    }

    @Override
    public TreeNode<T> addChild(TreeNode<T> child) {
        child.setParent(this);
        this.m_mapChildren.put(child.getName(), child);
        return child;
    }

    @Override
    public TreeNode<T> removeChild(String name) {
        return this.m_mapChildren.remove(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.m_mapNodeProps == null) {
            this.m_mapNodeProps = new LinkedHashMap<String, Object>();
        }
        this.m_mapNodeProps.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.m_mapNodeProps == null ? null : this.m_mapNodeProps.get(name);
    }

    @Override
    public String getStringProperty(String name) {
        Object value = this.getProperty(name);
        return value == null ? null : value.toString();
    }

    @Override
    public void removeProperty(String name) {
        if (this.m_mapNodeProps != null) {
            this.m_mapNodeProps.remove(name);
        }
    }

    @Override
    public TreeNode<T> getChild(String name) {
        if (name != null && name.contains("/")) {
            int i = name.indexOf(47);
            String s = name.substring(0, i);
            TreeNode<T> node = this.m_mapChildren.get(s);
            return node == null ? null : node.getChild(name.substring(i + 1));
        }
        return this.m_mapChildren.get(name);
    }
}

