/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.stomp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.events.listeners.tasks.TaskStatusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NamedTasksSubscriptions {
    private static Logger LOG = LoggerFactory.getLogger(NamedTasksSubscriptions.class);
    private ConcurrentHashMap<String, List<SubscriptionId>> taskIds = new ConcurrentHashMap();
    private final String subscriptionPrefix = "/events/tasks/";
    private final Lock taskIdsLock = new ReentrantLock();
    private Provider<TaskStatusListener> taskStatusListenerProvider;

    @Inject
    public NamedTasksSubscriptions(Provider<TaskStatusListener> taskStatusListenerProvider) {
        this.taskStatusListenerProvider = taskStatusListenerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskId(String sessionId, Long taskId, String id) {
        try {
            this.taskIdsLock.lock();
            this.taskIds.compute(sessionId, (sid, ids) -> {
                if (ids == null) {
                    ids = new ArrayList<SubscriptionId>();
                }
                AtomicBoolean completed = new AtomicBoolean(false);
                ((TaskStatusListener)this.taskStatusListenerProvider.get()).getActiveTasksMap().computeIfPresent(taskId, (tid, task) -> {
                    if (task.getStatus().isCompletedState()) {
                        completed.set(true);
                    }
                    return task;
                });
                if (!completed.get()) {
                    ids.add(new SubscriptionId(taskId, id));
                }
                return ids;
            });
            LOG.debug(String.format("Task subscription was added for sessionId = %s, taskId = %s, id = %s", sessionId, taskId, id));
        }
        finally {
            this.taskIdsLock.unlock();
        }
    }

    public void removeId(String sessionId, String id) {
        this.taskIds.computeIfPresent(sessionId, (sid, tasks) -> {
            Iterator iterator = tasks.iterator();
            while (iterator.hasNext()) {
                if (!((SubscriptionId)iterator.next()).getId().equals(id)) continue;
                iterator.remove();
                LOG.debug(String.format("Task subscription was removed for sessionId = %s, id = %s", sessionId, id));
            }
            return tasks;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskId(Long taskId) {
        try {
            this.taskIdsLock.lock();
            for (String sessionId : this.taskIds.keySet()) {
                this.taskIds.computeIfPresent(sessionId, (id, tasks) -> {
                    Iterator iterator = tasks.iterator();
                    while (iterator.hasNext()) {
                        if (!((SubscriptionId)iterator.next()).getTaskId().equals(taskId)) continue;
                        iterator.remove();
                        LOG.debug(String.format("Task subscription was removed for sessionId = %s and taskId = %s", sessionId, taskId));
                    }
                    return tasks;
                });
            }
        }
        finally {
            this.taskIdsLock.unlock();
        }
    }

    public void removeSession(String sessionId) {
        try {
            this.taskIdsLock.lock();
            this.taskIds.remove(sessionId);
            LOG.debug(String.format("Task subscriptions were removed for sessionId = %s", sessionId));
        }
        finally {
            this.taskIdsLock.unlock();
        }
    }

    public Optional<Long> matchDestination(String destination) {
        Optional<Long> taskIdOpt = Optional.of(StringUtils.substringAfter((String)destination, (String)"/events/tasks/")).filter(StringUtils::isNotEmpty).filter(StringUtils::isNumeric).map(Long::parseLong);
        return taskIdOpt;
    }

    public void addDestination(String sessionId, String destination, String id) {
        Optional<Long> taskIdOpt = this.matchDestination(destination);
        if (taskIdOpt.isPresent()) {
            this.addTaskId(sessionId, taskIdOpt.get(), id);
        }
    }

    public boolean checkTaskId(Long taskId) {
        for (List<SubscriptionId> ids : this.taskIds.values()) {
            for (SubscriptionId subscriptionId : ids) {
                if (!subscriptionId.getTaskId().equals(taskId)) continue;
                return true;
            }
        }
        return false;
    }

    public class SubscriptionId {
        private final Long taskId;
        private final String id;

        public SubscriptionId(Long taskId, String id) {
            this.taskId = taskId;
            this.id = id;
        }

        public Long getTaskId() {
            return this.taskId;
        }

        public String getId() {
            return this.id;
        }
    }
}

