/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.stomp;

import id.onyx.obdp.server.api.stomp.NamedTasksSubscriptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;
import org.springframework.web.socket.messaging.SessionUnsubscribeEvent;

@Component
public class NamedTasksSubscribeListener {
    private static Logger LOG = LoggerFactory.getLogger(NamedTasksSubscribeListener.class);
    @Autowired
    private NamedTasksSubscriptions namedTasksSubscriptions;

    @EventListener
    public void subscribe(SessionSubscribeEvent sse) {
        MessageHeaders msgHeaders = sse.getMessage().getHeaders();
        String sessionId = (String)msgHeaders.get((Object)"simpSessionId");
        String destination = (String)msgHeaders.get((Object)"simpDestination");
        String id = (String)msgHeaders.get((Object)"simpSubscriptionId");
        if (sessionId != null && destination != null && id != null) {
            this.namedTasksSubscriptions.addDestination(sessionId, destination, id);
        }
        LOG.debug(String.format("API subscribe was arrived with sessionId = %s, destination = %s and id = %s", sessionId, destination, id));
    }

    @EventListener
    public void unsubscribe(SessionUnsubscribeEvent suse) {
        MessageHeaders msgHeaders = suse.getMessage().getHeaders();
        String sessionId = (String)msgHeaders.get((Object)"simpSessionId");
        String id = (String)msgHeaders.get((Object)"simpSubscriptionId");
        if (sessionId != null && id != null) {
            this.namedTasksSubscriptions.removeId(sessionId, id);
        }
        LOG.debug(String.format("API unsubscribe was arrived with sessionId = %s and id = %s", sessionId, id));
    }

    @EventListener
    public void disconnect(SessionDisconnectEvent sde) {
        MessageHeaders msgHeaders = sde.getMessage().getHeaders();
        String sessionId = (String)msgHeaders.get((Object)"simpSessionId");
        if (sessionId != null) {
            this.namedTasksSubscriptions.removeSession(sessionId);
        }
        LOG.debug(String.format("API disconnect was arrived with sessionId = %s", sessionId));
    }
}

